/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.AttributesEncoder;
import dev.fileformat.drako.DracoEncodeOptions;
import dev.fileformat.drako.DracoPointCloud;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.PointCloudEncoder;
import dev.fileformat.drako.PointsSequencer;
import dev.fileformat.drako.SequentialAttributeEncoder;
import dev.fileformat.drako.SequentialIntegerAttributeEncoder;
import dev.fileformat.drako.SequentialNormalAttributeEncoder;
import dev.fileformat.drako.SequentialQuantizationAttributeEncoder;

class SequentialAttributeEncodersController
extends AttributesEncoder {
    private int attId;
    private PointsSequencer sequencer;
    private SequentialAttributeEncoder[] sequentialEncoders;
    private int[] pointIds;

    public SequentialAttributeEncodersController(PointsSequencer sequencer, int attId) {
        super(attId);
        this.sequencer = sequencer;
        this.attId = attId;
    }

    @Override
    public void initialize(PointCloudEncoder encoder, DracoPointCloud pc) throws DrakoException {
        super.initialize(encoder, pc);
        this.createSequentialEncoders();
        for (int i = 0; i < this.getNumAttributes(); ++i) {
            int attId = this.getAttributeId(i);
            this.sequentialEncoders[i].initialize(encoder, attId);
        }
    }

    @Override
    public boolean markParentAttribute(int pointAttributeId) {
        int loc_id = this.getLocalIdForPointAttribute(pointAttributeId);
        if (loc_id < 0) {
            return false;
        }
        this.sequentialEncoders[loc_id].markParentAttribute();
        return true;
    }

    protected void createSequentialEncoders() throws DrakoException {
        this.sequentialEncoders = new SequentialAttributeEncoder[this.getNumAttributes()];
        for (int i = 0; i < this.getNumAttributes(); ++i) {
            this.sequentialEncoders[i] = this.createSequentialEncoder(i);
            if (this.sequentialEncoders[i] != null) continue;
            throw DracoUtils.failed();
        }
    }

    protected SequentialAttributeEncoder createSequentialEncoder(int i) {
        int attId = this.getAttributeId(i);
        PointAttribute att = this.getEncoder().getPointCloud().attribute(attId);
        switch (att.getDataType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return new SequentialIntegerAttributeEncoder();
            }
            case 9: {
                int quantBits = 0;
                DracoEncodeOptions opts = this.getEncoder().getOptions();
                if (att.getAttributeType() == 1) {
                    quantBits = opts.getNormalBits();
                }
                switch (att.getAttributeType()) {
                    case 1: {
                        quantBits = opts.getNormalBits();
                        break;
                    }
                    case 2: {
                        quantBits = opts.getColorBits();
                        break;
                    }
                    case 0: {
                        quantBits = opts.getPositionBits();
                        break;
                    }
                    case 3: {
                        quantBits = opts.getTextureCoordinateBits();
                    }
                }
                if (quantBits <= 0) break;
                if (att.getAttributeType() == 1) {
                    return new SequentialNormalAttributeEncoder();
                }
                return new SequentialQuantizationAttributeEncoder();
            }
        }
        return new SequentialAttributeEncoder();
    }

    @Override
    public void encodeAttributesEncoderData(EncoderBuffer outBuffer) {
        super.encodeAttributesEncoderData(outBuffer);
        for (int i = 0; i < this.sequentialEncoders.length; ++i) {
            outBuffer.encode((byte)this.sequentialEncoders[i].getUniqueId());
        }
    }

    @Override
    public void encodeAttributes(EncoderBuffer outBuffer) throws DrakoException {
        if (this.sequencer == null) {
            throw DracoUtils.failed();
        }
        this.pointIds = this.sequencer.generateSequence();
        super.encodeAttributes(outBuffer);
    }

    @Override
    protected void transformAttributesToPortableFormat() {
        for (int i = 0; i < this.sequentialEncoders.length; ++i) {
            this.sequentialEncoders[i].transformAttributeToPortableFormat(this.pointIds);
        }
    }

    @Override
    protected void encodePortableAttributes(EncoderBuffer out_buffer) throws DrakoException {
        for (int i = 0; i < this.sequentialEncoders.length; ++i) {
            this.sequentialEncoders[i].encodePortableAttribute(this.pointIds, out_buffer);
        }
    }

    @Override
    protected void encodeDataNeededByPortableTransforms(EncoderBuffer out_buffer) throws DrakoException {
        for (int i = 0; i < this.sequentialEncoders.length; ++i) {
            this.sequentialEncoders[i].encodeDataNeededByPortableTransform(out_buffer);
        }
    }

    @Override
    public PointAttribute getPortableAttribute(int parentAttId) {
        int loc_id = this.getLocalIdForPointAttribute(parentAttId);
        if (loc_id < 0) {
            return null;
        }
        return this.sequentialEncoders[loc_id].portableAttribute;
    }

    @Override
    public byte getUniqueId() {
        return 0;
    }
}

