/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.BytePointer;
import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.Decoding;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.RAnsBitCodec;
import dev.fileformat.drako.RAnsDecoder;

class RAnsSymbolDecoder
extends RAnsBitCodec {
    private int maxSymbolBitLength;
    private int maxSymbols;
    private int ransPrecision;
    private int[] probabilityTable;
    private int numSymbols;
    private RAnsDecoder ans;

    public RAnsSymbolDecoder(int maxSymbolBitLength) {
        this.maxSymbolBitLength = maxSymbolBitLength;
        this.maxSymbols = 1 << maxSymbolBitLength;
        int ransPrecisionBits = RAnsBitCodec.computeRAnsPrecisionFromMaxSymbolBitLength(maxSymbolBitLength);
        this.ransPrecision = 1 << ransPrecisionBits;
        this.ans = new RAnsDecoder(ransPrecisionBits);
    }

    public void create(DecoderBuffer buffer) throws DrakoException {
        int n;
        if (buffer.getBitstreamVersion() == 0) {
            throw DracoUtils.failed();
        }
        this.numSymbols = buffer.getBitstreamVersion() < 20 ? buffer.decodeI32() : (n = Decoding.decodeVarintU32(buffer));
        this.probabilityTable = new int[this.numSymbols];
        if (this.numSymbols == 0) {
            return;
        }
        for (int i = 0; i < this.numSymbols; ++i) {
            int prob = 0;
            byte byteProb = buffer.decodeU8();
            int token = 0xFF & byteProb & 3;
            if (token == 3) {
                int offset = (0xFF & byteProb) >>> 2;
                if (i + offset >= this.numSymbols) {
                    throw DracoUtils.failed();
                }
                for (int j = 0; j < offset + 1; ++j) {
                    this.probabilityTable[i + j] = 0;
                }
                i += offset;
            } else {
                int extraBytes = 0xFF & byteProb & 3;
                prob = (0xFF & byteProb) >>> 2;
                for (int b = 0; b < extraBytes; ++b) {
                    byte eb = buffer.decodeU8();
                    prob |= (0xFF & eb) << 8 * (b + 1) - 2;
                }
            }
            this.probabilityTable[i] = prob;
        }
        if (!this.ans.buildLookupTable(this.probabilityTable, this.numSymbols)) {
            throw DracoUtils.failed();
        }
    }

    public void startDecoding(DecoderBuffer buffer) throws DrakoException {
        long n;
        long bytesEncoded = buffer.getBitstreamVersion() < 20 ? buffer.decodeI64() : (n = Decoding.decodeVarintU64(buffer));
        if (bytesEncoded > (long)buffer.getRemainingSize()) {
            throw DracoUtils.failed();
        }
        BytePointer dataHead = BytePointer.add(buffer.getPointer(), buffer.getDecodedSize());
        buffer.advance((int)bytesEncoded);
        if (this.ans.readInit(dataHead, (int)bytesEncoded) != 0) {
            throw DracoUtils.failed();
        }
    }

    public int getNumSymbols() {
        return this.numSymbols;
    }

    public int decodeSymbol() {
        return this.ans.read();
    }

    public void endDecoding() {
        this.ans.readEnd();
    }
}

