/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.BytePointer;
import dev.fileformat.drako.RAnsBitCodec;
import dev.fileformat.drako.Unsafe;

class RAnsEncoder
extends RAnsBitCodec {
    private int precisionBits;
    private int ransPrecision;
    private int lRansBase;
    private BytePointer buf = new BytePointer();
    private int bufOffset;
    private int state;

    public RAnsEncoder(int precisionBits) {
        this.precisionBits = precisionBits;
        this.ransPrecision = 1 << precisionBits;
        this.lRansBase = this.ransPrecision * 4;
    }

    public void reset(BytePointer ptr) {
        this.buf.copyFrom(ptr);
        this.bufOffset = 0;
        this.state = this.lRansBase;
    }

    public int writeEnd() {
        int state = this.state - this.lRansBase;
        if ((0xFFFFFFFFL & (long)state) < 64L) {
            this.buf.set(this.bufOffset, (byte)(0 + state));
            return this.bufOffset + 1;
        }
        if ((0xFFFFFFFFL & (long)state) < 16384L) {
            Unsafe.putLE16(this.buf.getBaseData(), this.buf.getOffset() + this.bufOffset, (short)(16384 + state));
            return this.bufOffset + 2;
        }
        if ((0xFFFFFFFFL & (long)state) < 0x400000L) {
            Unsafe.putLE24(this.buf.getBaseData(), this.buf.getOffset() + this.bufOffset, 0x800000 + state);
            return this.bufOffset + 3;
        }
        if ((0xFFFFFFFFL & (long)state) < 0x40000000L) {
            Unsafe.putLE32(this.buf.getBaseData(), this.buf.getOffset() + this.bufOffset, -1073741824 + state);
            return this.bufOffset + 4;
        }
        throw new RuntimeException("Invalid rANS state.");
    }

    public void write(RAnsBitCodec.RansSym sym) {
        int p = sym.prob;
        while ((0xFFFFFFFFL & (long)this.state) >= (long)(this.lRansBase / this.ransPrecision * 256 * p)) {
            this.buf.set(this.bufOffset++, (byte)(this.state % 256));
            this.state /= 256;
        }
        this.state = this.state / p * this.ransPrecision + this.state % p + sym.cumProb;
    }
}

