/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.BytePointer;
import dev.fileformat.drako.HashBuilder;
import dev.fileformat.drako.MetaClasses;
import dev.fileformat.drako.Struct;
import java.io.Serializable;

class RAnsDecoder {
    private static final int IO_BASE = 256;
    private int ransPrecisionBits;
    private int ransPrecision;
    private int lRansBase;
    private int[] lutTable;
    private ransSym[] probabilityTable;
    private BytePointer buf = new BytePointer();
    private int bufOffset;
    private int state;

    public RAnsDecoder(int ransPrecisionBits) {
        this.ransPrecisionBits = ransPrecisionBits;
        this.ransPrecision = 1 << ransPrecisionBits;
        this.lRansBase = this.ransPrecision * 4;
    }

    public int readInit(BytePointer buf, int offset) {
        BytePointer bytePointer = buf = buf == null ? new BytePointer() : buf.clone();
        if (offset < 1) {
            return 1;
        }
        this.buf.copyFrom(buf);
        int x = (0xFF & buf.get(offset - 1)) >>> 6;
        if (x == 0) {
            this.bufOffset = offset - 1;
            this.state = 0xFF & buf.get(offset - 1) & 0x3F;
        } else if (x == 1) {
            if (offset < 2) {
                return 1;
            }
            this.bufOffset = offset - 2;
            this.state = 0xFFFF & buf.toUInt16LE(offset - 2) & 0x3FFF;
        } else if (x == 2) {
            if (offset < 3) {
                return 1;
            }
            this.bufOffset = offset - 3;
            this.state = buf.toUInt24LE(offset - 3) & 0x3FFFFF;
        } else if (x == 3) {
            this.bufOffset = offset - 4;
            this.state = buf.toUInt32LE(offset - 4) & 0x3FFFFFFF;
        } else {
            return 1;
        }
        this.state += this.lRansBase;
        if ((0xFFFFFFFFL & (long)this.state) >= (long)(this.lRansBase * 256)) {
            return 1;
        }
        return 0;
    }

    public boolean readEnd() {
        return this.state == this.lRansBase;
    }

    public boolean readerHasError() {
        return (0xFFFFFFFFL & (long)this.state) < (long)this.lRansBase && this.bufOffset == 0;
    }

    public int read() {
        ransDecSym sym = new ransDecSym();
        while ((0xFFFFFFFFL & (long)this.state) < (long)this.lRansBase && this.bufOffset > 0) {
            this.state = this.state * 256 + (0xFF & this.buf.get(--this.bufOffset));
        }
        int quo = this.state / this.ransPrecision;
        int rem = this.state % this.ransPrecision;
        this.fetchSym(sym, rem);
        this.state = quo * sym.prob + rem - sym.cumProb;
        return sym.val;
    }

    public boolean buildLookupTable(int[] tokenProbs, int numSymbols) {
        this.lutTable = new int[this.ransPrecision];
        this.probabilityTable = (ransSym[])MetaClasses.ransSym.newArray(numSymbols);
        int cumProb = 0;
        int actProb = 0;
        for (int i = 0; i < numSymbols; ++i) {
            ransSym sym = new ransSym();
            sym.prob = tokenProbs[i];
            sym.cumProb = cumProb;
            this.probabilityTable[i] = Struct.byVal(sym);
            if ((0xFFFFFFFFL & (long)(cumProb += tokenProbs[i])) > (long)this.ransPrecision) {
                return false;
            }
            int j = actProb;
            while ((long)j < (0xFFFFFFFFL & (long)cumProb)) {
                this.lutTable[j] = i;
                ++j;
            }
            actProb = cumProb;
        }
        return (0xFFFFFFFFL & (long)cumProb) == (long)this.ransPrecision;
    }

    private void fetchSym(ransDecSym res, int rem) {
        int symbol;
        res.val = symbol = this.lutTable[rem];
        res.prob = this.probabilityTable[symbol].prob;
        res.cumProb = this.probabilityTable[symbol].cumProb;
    }

    static final class ransSym
    implements Struct<ransSym>,
    Serializable {
        int prob;
        int cumProb;
        static final long serialVersionUID = 31145064L;

        public ransSym() {
        }

        private ransSym(ransSym other) {
            this.prob = other.prob;
            this.cumProb = other.cumProb;
        }

        @Override
        public ransSym clone() {
            return new ransSym(this);
        }

        @Override
        public void copyFrom(ransSym src) {
            if (src == null) {
                return;
            }
            this.prob = src.prob;
            this.cumProb = src.cumProb;
        }

        public int hashCode() {
            HashBuilder builder = new HashBuilder();
            builder.hash(this.prob);
            builder.hash(this.cumProb);
            return builder.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ransSym)) {
                return false;
            }
            ransSym rhs = (ransSym)obj;
            if (this.prob != rhs.prob) {
                return false;
            }
            return this.cumProb == rhs.cumProb;
        }
    }

    static final class ransDecSym
    implements Struct<ransDecSym>,
    Serializable {
        int val;
        int prob;
        int cumProb;
        static final long serialVersionUID = 1044714435L;

        public ransDecSym() {
        }

        private ransDecSym(ransDecSym other) {
            this.val = other.val;
            this.prob = other.prob;
            this.cumProb = other.cumProb;
        }

        @Override
        public ransDecSym clone() {
            return new ransDecSym(this);
        }

        @Override
        public void copyFrom(ransDecSym src) {
            if (src == null) {
                return;
            }
            this.val = src.val;
            this.prob = src.prob;
            this.cumProb = src.cumProb;
        }

        public int hashCode() {
            HashBuilder builder = new HashBuilder();
            builder.hash(this.val);
            builder.hash(this.prob);
            builder.hash(this.cumProb);
            return builder.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ransDecSym)) {
                return false;
            }
            ransDecSym rhs = (ransDecSym)obj;
            if (this.val != rhs.val) {
                return false;
            }
            if (this.prob != rhs.prob) {
                return false;
            }
            return this.cumProb == rhs.cumProb;
        }
    }
}

