/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.AsposeUtils;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.Encoding;
import dev.fileformat.drako.HashBuilder;
import dev.fileformat.drako.IBitEncoder;
import dev.fileformat.drako.RAnsBitCodec;
import dev.fileformat.drako.Struct;
import dev.fileformat.drako.Unsafe;
import java.io.Serializable;
import java.util.ArrayList;

class RAnsBitEncoder
extends RAnsBitCodec
implements IBitEncoder {
    private long[] bitCounts;
    private ArrayList<Integer> bits;
    private int localBits;
    private int numLocalBits;

    @Override
    public void startEncoding() {
        this.clear();
    }

    @Override
    public void encodeBit(boolean bit) {
        if (bit) {
            this.bitCounts[1] = this.bitCounts[1] + 1L;
            this.localBits |= 1 << this.numLocalBits;
        } else {
            this.bitCounts[0] = this.bitCounts[0] + 1L;
        }
        ++this.numLocalBits;
        if (this.numLocalBits == 32) {
            this.bits.add(this.localBits);
            this.numLocalBits = 0;
            this.localBits = 0;
        }
    }

    @Override
    public void encodeLeastSignificantBits32(int nbits, int value) {
        int reversed = DracoUtils.reverseBits32(value) >>> 32 - nbits;
        int ones = DracoUtils.countOnes32(reversed);
        int[] ref0 = new int[1];
        int[] ref1 = new int[1];
        int[] ref2 = new int[1];
        this.bitCounts[0] = this.bitCounts[0] + (long)(nbits - ones);
        this.bitCounts[1] = this.bitCounts[1] + (long)ones;
        int remaining = 32 - this.numLocalBits;
        if (nbits <= remaining) {
            ref0[0] = this.localBits;
            DracoUtils.copyBits32(ref0, this.numLocalBits, reversed, 0, nbits);
            this.localBits = ref0[0];
            this.numLocalBits += nbits;
            if (this.numLocalBits == 32) {
                this.bits.add(this.localBits);
                this.localBits = 0;
                this.numLocalBits = 0;
            }
        } else {
            ref1[0] = this.localBits;
            DracoUtils.copyBits32(ref1, this.numLocalBits, reversed, 0, remaining);
            this.localBits = ref1[0];
            this.bits.add(this.localBits);
            ref2[0] = this.localBits = 0;
            DracoUtils.copyBits32(ref2, 0, reversed, remaining, nbits - remaining);
            this.localBits = ref2[0];
            this.numLocalBits = nbits - remaining;
        }
    }

    @Override
    public void endEncoding(EncoderBuffer targetBuffer) {
        long total = this.bitCounts[1] + this.bitCounts[0];
        if (total == 0L) {
            ++total;
        }
        int zeroProbRaw = (int)((double)this.bitCounts[0] / (double)total * 256.0 + 0.5);
        byte zeroProb = -1;
        if ((0xFFFFFFFFL & (long)zeroProbRaw) < 255L) {
            zeroProb = (byte)zeroProbRaw;
        }
        zeroProb = (byte)(zeroProb + (byte)(zeroProb == 0 ? 1 : 0));
        byte[] buffer = new byte[(this.bits.size() + 8) * 8];
        AnsCoder ansCoder = new AnsCoder();
        RAnsBitEncoder.ansWriteInit(ansCoder, buffer);
        for (int i = this.numLocalBits - 1; i >= 0; --i) {
            int bit = this.localBits >>> i & 1;
            RAnsBitEncoder.rabsDescWrite(ansCoder, bit, zeroProb);
        }
        for (int j = this.bits.size() - 1; j >= 0; --j) {
            int nbits = this.bits.get(j);
            for (int i = 31; i >= 0; --i) {
                int bit = nbits >>> i & 1;
                RAnsBitEncoder.rabsDescWrite(ansCoder, bit, zeroProb);
            }
        }
        int sizeInBytes = RAnsBitEncoder.ansWriteEnd(ansCoder);
        targetBuffer.encode(zeroProb);
        Encoding.encodeVarint(sizeInBytes, targetBuffer);
        targetBuffer.encode(buffer, sizeInBytes);
        this.clear();
    }

    static void rabsDescWrite(AnsCoder ans, int val, byte p0) {
        int lS;
        int p = 256 - (0xFF & p0);
        int n = lS = val == 1 ? p : 0xFF & p0;
        if ((0xFFFFFFFFL & (long)ans.state) >= (long)(4096 * lS)) {
            ans.buf[ans.bufOffset++] = (byte)(ans.state % 256);
            ans.state /= 256;
        }
        int quot = ans.state / lS;
        int rem = ans.state - quot * lS;
        ans.state = quot * 256 + rem + (val == 1 ? 0 : p);
    }

    static void ansWriteInit(AnsCoder ans, byte[] buf) {
        ans.buf = buf;
        ans.bufOffset = 0;
        ans.state = 4096;
    }

    static int ansWriteEnd(AnsCoder ans) {
        int state = ans.state - 4096;
        if ((0xFFFFFFFFL & (long)state) < 64L) {
            ans.buf[ans.bufOffset] = (byte)(0 + state);
            return ans.bufOffset + 1;
        }
        if ((0xFFFFFFFFL & (long)state) < 16384L) {
            Unsafe.putLE16(ans.buf, ans.bufOffset, (short)(16384 + state));
            return ans.bufOffset + 2;
        }
        if ((0xFFFFFFFFL & (long)state) < 0x400000L) {
            Unsafe.putLE24(ans.buf, ans.bufOffset, 0x800000 + state);
            return ans.bufOffset + 3;
        }
        throw new RuntimeException("Invalid RAns state");
    }

    @Override
    public void clear() {
        this.bitCounts[0] = 0L;
        this.bitCounts[1] = 0L;
        this.bits.clear();
        this.localBits = 0;
        this.numLocalBits = 0;
    }

    public RAnsBitEncoder() {
        this.$initFields$();
    }

    private void $initFields$() {
        try {
            this.bitCounts = new long[2];
            this.bits = new ArrayList();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static final class AnsCoder
    implements Struct<AnsCoder>,
    Serializable {
        byte[] buf;
        int bufOffset;
        int state;
        static final long serialVersionUID = 1988767698L;

        public AnsCoder() {
        }

        private AnsCoder(AnsCoder other) {
            this.buf = other.buf;
            this.bufOffset = other.bufOffset;
            this.state = other.state;
        }

        @Override
        public AnsCoder clone() {
            return new AnsCoder(this);
        }

        @Override
        public void copyFrom(AnsCoder src) {
            if (src == null) {
                return;
            }
            this.buf = src.buf;
            this.bufOffset = src.bufOffset;
            this.state = src.state;
        }

        public int hashCode() {
            HashBuilder builder = new HashBuilder();
            builder.hash(this.buf);
            builder.hash(this.bufOffset);
            builder.hash(this.state);
            return builder.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AnsCoder)) {
                return false;
            }
            AnsCoder rhs = (AnsCoder)obj;
            if (!AsposeUtils.equals(this.buf, rhs.buf)) {
                return false;
            }
            if (this.bufOffset != rhs.bufOffset) {
                return false;
            }
            return this.state == rhs.state;
        }
    }
}

