/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.PredictionSchemeTransform;
import java.util.Arrays;

class PredictionSchemeWrapTransform
extends PredictionSchemeTransform {
    private int minValue;
    private int maxValue;
    private int maxDif;
    private int maxCorrection;
    private int minCorrection;
    private int[] clampedValue;

    protected void initCorrectionBounds() {
        this.maxDif = 1 + this.maxValue - this.minValue;
        this.maxCorrection = this.maxDif / 2;
        this.minCorrection = -this.maxCorrection;
        if ((this.maxDif & 1) == 0) {
            --this.maxCorrection;
        }
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void initializeEncoding(IntSpan origData, int numComponents) {
        int tmp0;
        super.initializeEncoding(origData, numComponents);
        if (origData.size() == 0) {
            return;
        }
        this.maxValue = tmp0 = origData.get(0);
        this.minValue = tmp0;
        for (int i = 1; i < origData.size(); ++i) {
            if (origData.get(i) < this.minValue) {
                this.minValue = origData.get(i);
                continue;
            }
            if (origData.get(i) <= this.maxValue) continue;
            this.maxValue = origData.get(i);
        }
        this.initCorrectionBounds();
        this.clampedValue = this.clampedValue == null ? new int[numComponents] : Arrays.copyOf(this.clampedValue, numComponents);
    }

    @Override
    public void initializeDecoding(int numComponents) {
        super.initializeDecoding(numComponents);
        this.clampedValue = this.clampedValue == null ? new int[numComponents] : Arrays.copyOf(this.clampedValue, numComponents);
    }

    @Override
    public void computeCorrection(IntSpan originalVals, int originalOffset, IntSpan predictedVals, int predictedOffset, IntSpan outCorrVals, int outOffset, int valId) {
        super.computeCorrection(originalVals, originalOffset, this.clampPredictedValue(predictedVals, predictedOffset), 0, outCorrVals, outOffset, valId);
        for (int i = 0; i < this.numComponents; ++i) {
            int idx = outOffset + valId + i;
            int corrVal = outCorrVals.get(idx);
            if (corrVal < this.minCorrection) {
                outCorrVals.put(idx, corrVal + this.maxDif);
                continue;
            }
            if (corrVal <= this.maxCorrection) continue;
            outCorrVals.put(idx, corrVal - this.maxDif);
        }
    }

    @Override
    public void computeOriginalValue(IntSpan predictedVals, int predictedOffset, IntSpan corrVals, int corrOffset, IntSpan outOriginalVals, int outOffset) {
        predictedVals = this.clampPredictedValue(predictedVals, predictedOffset);
        for (int i = 0; i < this.numComponents; ++i) {
            int n = i + outOffset;
            outOriginalVals.put(n, predictedVals.get(i) + corrVals.get(i + corrOffset));
            if (outOriginalVals.get(n) > this.maxValue) {
                outOriginalVals.put(n, outOriginalVals.get(n) - this.maxDif);
                continue;
            }
            if (outOriginalVals.get(n) >= this.minValue) continue;
            outOriginalVals.put(n, outOriginalVals.get(n) + this.maxDif);
        }
    }

    IntSpan clampPredictedValue(IntSpan predictedVal, int offset) {
        for (int i = 0; i < this.numComponents; ++i) {
            int v = predictedVal.get(i + offset);
            this.clampedValue[i] = v > this.maxValue ? this.maxValue : (v < this.minValue ? this.minValue : v);
        }
        return IntSpan.wrap(this.clampedValue);
    }

    @Override
    public void encodeTransformData(EncoderBuffer buffer) {
        buffer.encode2(this.minValue);
        buffer.encode2(this.maxValue);
    }

    @Override
    public void decodeTransformData(DecoderBuffer buffer) throws DrakoException {
        this.minValue = buffer.decodeI32();
        this.maxValue = buffer.decodeI32();
        this.initCorrectionBounds();
    }

    public PredictionSchemeWrapTransform() {
        this.$initFields$();
    }

    private void $initFields$() {
        try {
            this.clampedValue = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

