/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DracoMesh;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.ICornerTable;
import dev.fileformat.drako.ICornerTableTraverser;
import dev.fileformat.drako.IntList;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.MeshAttributeIndicesEncodingData;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.PointsSequencer;

class MeshTraversalSequencer<TCornerTable extends ICornerTable>
extends PointsSequencer {
    private ICornerTableTraverser<TCornerTable> traverser;
    private DracoMesh mesh;
    private MeshAttributeIndicesEncodingData encodingData;
    private IntList cornerOrder;

    public MeshTraversalSequencer(DracoMesh mesh, MeshAttributeIndicesEncodingData encodingData) {
        this.mesh = mesh;
        this.encodingData = encodingData;
    }

    public void setTraverser(ICornerTableTraverser<TCornerTable> t) {
        this.traverser = t;
    }

    public void setCornerOrder(IntList cornerOrder) {
        this.cornerOrder = cornerOrder;
    }

    @Override
    public void updatePointToAttributeIndexMapping(PointAttribute attribute) throws DrakoException {
        TCornerTable cornerTable = this.traverser.getCornerTable();
        attribute.setExplicitMapping(this.mesh.getNumPoints());
        int numFaces = this.mesh.getNumFaces();
        int numPoints = this.mesh.getNumPoints();
        IntSpan face = IntSpan.wrap(new int[3]);
        for (int f = 0; f < numFaces; ++f) {
            this.mesh.readFace(f, face);
            for (int p = 0; p < 3; ++p) {
                int pointId = face.get(p);
                int vertId = ((ICornerTable)cornerTable).vertex(3 * f + p);
                int attEntryId = this.encodingData.vertexToEncodedAttributeValueIndexMap[vertId];
                if (attEntryId >= numPoints) {
                    throw DracoUtils.failed();
                }
                attribute.setPointMapEntry(pointId, attEntryId);
            }
        }
    }

    @Override
    protected void generateSequenceInternal() throws DrakoException {
        this.traverser.onTraversalStart();
        if (this.cornerOrder != null) {
            for (int i = 0; i < this.cornerOrder.getCount(); ++i) {
                this.processCorner(this.cornerOrder.get(i));
            }
        } else {
            int num_faces = ((ICornerTable)this.traverser.getCornerTable()).getNumFaces();
            for (int i = 0; i < num_faces; ++i) {
                this.processCorner(3 * i);
            }
        }
        this.traverser.onTraversalEnd();
    }

    private void processCorner(int cornerId) throws DrakoException {
        this.traverser.traverseFromCorner(cornerId);
    }
}

