/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.CornerTable;
import dev.fileformat.drako.DracoMesh;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.ICornerTable;
import dev.fileformat.drako.IntList;
import dev.fileformat.drako.PointAttribute;

class MeshAttributeCornerTable
extends ICornerTable {
    private static final int K_INVALID_VERTEX_INDEX = -1;
    private static final int K_INVALID_CORNER_INDEX = -1;
    private boolean[] isEdgeOnSeam;
    private boolean[] isVertexOnSeam;
    private boolean noInteriorSeams = true;
    private int[] cornerToVertexMap;
    private IntList vertexToLeftMostCornerMap;
    private IntList vertexToAttributeEntryIdMap;
    private CornerTable cornerTable;

    public MeshAttributeCornerTable(CornerTable table) {
        this.$initFields$();
        this.isEdgeOnSeam = new boolean[table.getNumCorners()];
        this.isVertexOnSeam = new boolean[table.getNumVertices()];
        this.cornerToVertexMap = new int[table.getNumCorners()];
        for (int i = 0; i < this.cornerToVertexMap.length; ++i) {
            this.cornerToVertexMap[i] = -1;
        }
        this.vertexToAttributeEntryIdMap.setCapacity(table.getNumVertices());
        this.vertexToLeftMostCornerMap.setCapacity(table.getNumVertices());
        this.cornerTable = table;
        this.noInteriorSeams = true;
    }

    public MeshAttributeCornerTable(DracoMesh mesh, CornerTable table, PointAttribute att) {
        this(table);
        block0: for (int c = 0; c < this.cornerTable.getNumCorners(); ++c) {
            int f = this.cornerTable.face(c);
            if (this.cornerTable.isDegenerated(f)) continue;
            int oppCorner = this.cornerTable.opposite(c);
            if (oppCorner < 0) {
                this.isEdgeOnSeam[c] = true;
                int v = this.cornerTable.vertex(this.cornerTable.next(c));
                this.isVertexOnSeam[v] = true;
                v = this.cornerTable.vertex(this.cornerTable.previous(c));
                this.isVertexOnSeam[v] = true;
                continue;
            }
            if (oppCorner < c) continue;
            int actC = c;
            int actSiblingC = oppCorner;
            for (int i = 0; i < 2; ++i) {
                actC = this.cornerTable.next(actC);
                actSiblingC = this.cornerTable.previous(actSiblingC);
                int pointId = DracoUtils.cornerToPointId(actC, mesh);
                int siblingPointId = DracoUtils.cornerToPointId(actSiblingC, mesh);
                if (att.mappedIndex(pointId) == att.mappedIndex(siblingPointId)) continue;
                this.noInteriorSeams = false;
                this.isEdgeOnSeam[c] = true;
                this.isEdgeOnSeam[oppCorner] = true;
                this.isVertexOnSeam[this.cornerTable.vertex((int)this.cornerTable.next((int)c))] = true;
                this.isVertexOnSeam[this.cornerTable.vertex((int)this.cornerTable.previous((int)c))] = true;
                this.isVertexOnSeam[this.cornerTable.vertex((int)this.cornerTable.next((int)oppCorner))] = true;
                this.isVertexOnSeam[this.cornerTable.vertex((int)this.cornerTable.previous((int)oppCorner))] = true;
                continue block0;
            }
        }
        this.recomputeVertices(mesh, att);
    }

    public void addSeamEdge(int c) {
        this.isEdgeOnSeam[c] = true;
        this.isVertexOnSeam[this.cornerTable.vertex((int)this.cornerTable.next((int)c))] = true;
        this.isVertexOnSeam[this.cornerTable.vertex((int)this.cornerTable.previous((int)c))] = true;
        int oppCorner = this.cornerTable.opposite(c);
        if (oppCorner >= 0) {
            this.noInteriorSeams = false;
            this.isEdgeOnSeam[oppCorner] = true;
            this.isVertexOnSeam[this.cornerTable.vertex((int)this.cornerTable.next((int)oppCorner))] = true;
            this.isVertexOnSeam[this.cornerTable.vertex((int)this.cornerTable.previous((int)oppCorner))] = true;
        }
    }

    public void recomputeVertices(DracoMesh mesh, PointAttribute att) {
        if (mesh != null && att != null) {
            this.recomputeVerticesInternal(true, mesh, att);
        } else {
            this.recomputeVerticesInternal(false, null, null);
        }
    }

    public void recomputeVerticesInternal(boolean initVertexToAttributeEntryMap, DracoMesh mesh, PointAttribute att) {
        int numNewVertices = 0;
        for (int v = 0; v < this.cornerTable.getNumVertices(); ++v) {
            int actC;
            int c = this.cornerTable.leftMostCorner(v);
            if (c < 0) continue;
            int firstVertId = numNewVertices++;
            if (initVertexToAttributeEntryMap) {
                int pointId = DracoUtils.cornerToPointId(c, mesh);
                this.vertexToAttributeEntryIdMap.add(att.mappedIndex(pointId));
            } else {
                this.vertexToAttributeEntryIdMap.add(firstVertId);
            }
            int firstC = c;
            if (this.isVertexOnSeam[v]) {
                actC = this.swingLeft(firstC);
                while (actC >= 0) {
                    firstC = actC;
                    actC = this.swingLeft(actC);
                }
            }
            this.cornerToVertexMap[firstC] = firstVertId;
            this.vertexToLeftMostCornerMap.add(firstC);
            actC = this.cornerTable.swingRight(firstC);
            while (actC >= 0 && actC != firstC) {
                if (this.isCornerOppositeToSeamEdge(this.cornerTable.next(actC))) {
                    firstVertId = numNewVertices++;
                    if (initVertexToAttributeEntryMap) {
                        int pointId = DracoUtils.cornerToPointId(actC, mesh);
                        this.vertexToAttributeEntryIdMap.add(att.mappedIndex(pointId));
                    } else {
                        this.vertexToAttributeEntryIdMap.add(firstVertId);
                    }
                    this.vertexToLeftMostCornerMap.add(actC);
                }
                this.cornerToVertexMap[actC] = firstVertId;
                actC = this.cornerTable.swingRight(actC);
            }
        }
    }

    public boolean isCornerOppositeToSeamEdge(int corner) {
        return this.isEdgeOnSeam[corner];
    }

    @Override
    public int opposite(int corner) {
        if (this.isCornerOppositeToSeamEdge(corner)) {
            return -1;
        }
        return this.cornerTable.opposite(corner);
    }

    public boolean isCornerOnSeam(int corner) {
        return this.isVertexOnSeam[this.cornerTable.vertex(corner)];
    }

    @Override
    public int getLeftCorner(int corner) {
        return this.opposite(this.previous(corner));
    }

    @Override
    public int getRightCorner(int corner) {
        return this.opposite(this.next(corner));
    }

    @Override
    public int swingRight(int corner) {
        return this.previous(this.opposite(this.previous(corner)));
    }

    @Override
    public int swingLeft(int corner) {
        return this.next(this.opposite(this.next(corner)));
    }

    @Override
    public int getNumVertices() {
        return this.vertexToAttributeEntryIdMap.getCount();
    }

    @Override
    public int getNumFaces() {
        return this.cornerTable.getNumFaces();
    }

    @Override
    public int vertex(int corner) {
        return this.cornerToVertexMap[corner];
    }

    public int vertexParent(int vert) {
        return this.vertexToAttributeEntryIdMap.get(vert);
    }

    @Override
    public int leftMostCorner(int v) {
        return this.vertexToLeftMostCornerMap.get(v);
    }

    @Override
    public boolean isOnBoundary(int vert) {
        int corner = this.leftMostCorner(vert);
        if (corner < 0) {
            return true;
        }
        return this.isCornerOnSeam(corner);
    }

    public boolean getNoInteriorSeams() {
        return this.noInteriorSeams;
    }

    CornerTable getCornerTable() {
        return this.cornerTable;
    }

    private void $initFields$() {
        try {
            this.vertexToLeftMostCornerMap = new IntList();
            this.vertexToAttributeEntryIdMap = new IntList();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

