/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.Stream;
import java.io.IOException;
import java.io.OutputStream;

public class MemoryStream
extends Stream
implements AutoCloseable {
    private static final int INITIAL_CAPACITY = 4096;
    protected byte[] data;
    protected int cursor;
    protected int size;

    public MemoryStream() {
        this.data = new byte[4096];
    }

    public MemoryStream(int capacity) {
        this.data = new byte[capacity];
    }

    public MemoryStream(byte[] data) {
        this.data = data;
        this.size = data.length;
    }

    private final void setCursor(int c) {
        this.cursor = c;
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getBuffer() {
        return this.data;
    }

    private void ensureCapacity(int expected) {
        int newCap;
        if (this.data != null && this.data.length >= expected) {
            return;
        }
        int n = newCap = this.data == null ? 0 : this.data.length;
        if (newCap == 0) {
            newCap = 4096;
        }
        while (newCap < expected) {
            newCap *= 2;
        }
        this.setCapacity(newCap);
    }

    public void setCapacity(int cap) {
        if (cap < 0) {
            throw new IllegalArgumentException();
        }
        byte[] newData = new byte[cap];
        if (this.data != null) {
            System.arraycopy(this.data, 0, newData, 0, Math.min(cap, this.data.length));
        }
        this.data = newData;
        if (this.size > cap) {
            this.size = cap;
        }
    }

    @Override
    public long getLength() {
        return this.size;
    }

    @Override
    public void setLength(long len) {
        this.ensureCapacity((int)len);
        this.size = (int)len;
        if (this.cursor > this.size) {
            this.setCursor(this.size);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public int readByte() throws IOException {
        if (this.cursor >= this.data.length) {
            return -1;
        }
        this.validateCursor();
        int n = this.cursor;
        this.setCursor(this.cursor + 1);
        return this.data[n];
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int start, int len) throws IOException {
        this.validateCursor();
        int l = Math.max(0, Math.min(Math.min(this.size - start, len), Math.min(this.size - this.cursor, len)));
        if (l == 0) {
            return 0;
        }
        System.arraycopy(this.data, this.cursor, buf, start, l);
        this.setCursor(this.cursor + l);
        return l;
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.validateCursor();
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int start, int len) throws IOException {
        this.validateCursor();
        this.ensureCapacity(this.cursor + len);
        System.arraycopy(buf, start, this.data, this.cursor, len);
        this.setCursor(this.cursor + len);
        if (this.cursor > this.size) {
            this.size = this.cursor;
        }
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.validateCursor();
        this.ensureCapacity(this.cursor + 1);
        this.data[this.cursor] = (byte)b;
        this.setCursor(this.cursor + 1);
        ++this.size;
    }

    @Override
    public long seek(long offset, int seek) throws IOException {
        switch (seek) {
            case 0: {
                this.setCursor((int)offset);
                break;
            }
            case 1: {
                this.setCursor(this.cursor + (int)offset);
                break;
            }
            case 2: {
                this.setCursor(this.size + (int)offset);
            }
        }
        return this.cursor;
    }

    private void validateCursor() {
        if (this.cursor < 0 || this.cursor > this.size) {
            throw new IllegalStateException("Invalid cursor");
        }
    }

    public byte[] toArray() {
        byte[] ret = new byte[this.size];
        if (this.size == 0) {
            return ret;
        }
        System.arraycopy(this.data, 0, ret, 0, this.size);
        return ret;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void copyTo(Stream stream) throws IOException {
        int rest = this.size - this.cursor;
        if (rest > 0) {
            stream.write(this.data, this.cursor, rest);
        }
    }

    public void copyTo(OutputStream stream) throws IOException {
        int rest = this.size - this.cursor;
        if (rest > 0) {
            stream.write(this.data, this.cursor, rest);
        }
    }
}

