/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.Internal;
import dev.fileformat.drako.Span;

@Internal
abstract class LongSpan
extends Span {
    public static LongSpan wrap(long[] array) {
        return new ArraySpan(array, 0, array.length);
    }

    public static LongSpan wrap(long[] array, int offset, int length) {
        return new ArraySpan(array, offset, array.length);
    }

    public static LongSpan wrap(byte[] array) {
        return new BytesSpan(array, 0, array.length / 8);
    }

    public static LongSpan wrap(byte[] array, int offset, int length) {
        return new BytesSpan(array, offset / 8, length / 8);
    }

    protected LongSpan(int offset, int length) {
        super(offset, length);
    }

    public abstract long get(int var1);

    public abstract void put(int var1, long var2);

    public abstract LongSpan slice(int var1, int var2);

    public LongSpan slice(int offset) {
        return this.slice(offset, this.length - offset);
    }

    public int compareTo(LongSpan span) {
        int num = Math.min(this.size(), span.size());
        for (int i = 0; i < num; ++i) {
            int n = Float.compare(this.get(i), span.get(i));
            if (n == 0) continue;
            return n;
        }
        return Integer.compare(this.size(), span.size());
    }

    public boolean equals(LongSpan span) {
        if (this.size() != span.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == span.get(i)) continue;
            return false;
        }
        return true;
    }

    public void copyTo(LongSpan span) {
        for (int i = 0; i < this.size(); ++i) {
            span.put(i, this.get(i));
        }
    }

    public void fill(long v) {
        for (int i = 0; i < this.size(); ++i) {
            this.put(i, v);
        }
    }

    private static final class BytesSpan
    extends LongSpan {
        private final byte[] array;

        public BytesSpan(byte[] array, int offset, int length) {
            super(offset, length);
            this.array = array;
        }

        @Override
        public long get(int idx) {
            this.rangeCheck(idx);
            int ptr = (idx + this.offset) * 8;
            return BytesSpan.getLongL(this.array, ptr);
        }

        @Override
        public void put(int idx, long value) {
            this.rangeCheck(idx);
            int ptr = (idx + this.offset) * 8;
            BytesSpan.putLongL(this.array, ptr, value);
        }

        @Override
        public LongSpan slice(int offset, int size) {
            return new BytesSpan(this.array, offset + this.offset, size);
        }
    }

    private static final class ArraySpan
    extends LongSpan {
        private final long[] array;

        public ArraySpan(long[] array, int offset, int length) {
            super(offset, length);
            this.array = array;
        }

        @Override
        public long get(int idx) {
            return this.array[idx + this.offset];
        }

        @Override
        public void put(int idx, long value) {
            this.rangeCheck(idx);
            this.array[idx + this.offset] = value;
        }

        @Override
        public LongSpan slice(int offset, int size) {
            return new ArraySpan(this.array, offset + this.offset, size);
        }
    }
}

