/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.Internal;
import dev.fileformat.drako.LinkedListIterator;
import dev.fileformat.drako.LinkedListNode;
import java.util.AbstractSequentialList;
import java.util.ListIterator;

@Internal
class LinkedList<E>
extends AbstractSequentialList<E> {
    private LinkedListNode<E> head;
    private LinkedListNode<E> tail;
    private int size;

    LinkedList() {
    }

    @Override
    public E removeFirst() {
        if (this.head == null) {
            return null;
        }
        E ret = this.head.getValue();
        this.remove(this.head);
        return ret;
    }

    @Override
    public E removeLast() {
        if (this.tail == null) {
            return null;
        }
        E ret = this.head.getValue();
        this.remove(this.tail);
        return ret;
    }

    @Override
    public LinkedListNode<E> getFirst() {
        return this.head;
    }

    @Override
    public LinkedListNode<E> getLast() {
        return this.tail;
    }

    @Override
    public E remove(int index) {
        this.rangeCheck(index);
        LinkedListNode<E> p = this.nodeAt(index);
        E ret = p.getValue();
        this.remove(p);
        return ret;
    }

    @Override
    public void add(int index, E value) {
        if (index == this.size) {
            this.addLast(value);
            return;
        }
        this.rangeCheck(index);
        if (index == 0) {
            this.addFirst(value);
        } else {
            LinkedListNode<E> p = this.nodeAt(index);
            this.addBefore(p, value);
        }
    }

    @Override
    public boolean add(E value) {
        this.addLast(value);
        return true;
    }

    public LinkedListNode<E> addFirst(E value) {
        LinkedListNode node = new LinkedListNode(this, value);
        this.link(node, this.head);
        if (this.tail == null) {
            this.tail = node;
        }
        ++this.size;
        return node;
    }

    public LinkedListNode<E> addBefore(LinkedListNode<E> node, E value) {
        LinkedListNode ret = new LinkedListNode(this, value);
        this.addBefore(node, ret);
        return ret;
    }

    public void addBefore(LinkedListNode<E> node, LinkedListNode<E> newNode) {
        if (node.list != this) {
            throw new IllegalStateException();
        }
        newNode.list = this;
        LinkedListNode prev = node.prev;
        ++this.size;
        this.link(prev, newNode);
        this.link(newNode, node);
    }

    private void link(LinkedListNode<E> before, LinkedListNode<E> after) {
        if (after == this.head) {
            this.head = before;
        }
        if (before == this.tail) {
            this.tail = after;
        }
        if (before != null) {
            before.setNext(after);
        }
        if (after != null) {
            after.prev = before;
        }
    }

    public LinkedListNode<E> addLast(E value) {
        LinkedListNode node = new LinkedListNode(this, value);
        this.addLast(node);
        return node;
    }

    public LinkedListNode<E> addLast(LinkedListNode<E> node) {
        if (this.tail != null) {
            this.tail.setNext(node);
            node.prev = this.tail;
        }
        node.list = this;
        this.tail = node;
        if (this.head == null) {
            this.head = node;
        }
        ++this.size;
        return node;
    }

    public void remove(LinkedListNode<E> node) {
        if (node.list != this) {
            throw new IllegalStateException("Cannot remove node from other list.");
        }
        this.link(node.prev, node.getNext());
        if (node == this.head) {
            this.head = node.getNext();
        }
        if (node == this.tail) {
            this.tail = node.prev;
        }
        node.prev = null;
        node.list = null;
        node.setNext(null);
        --this.size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.tail = null;
        this.head = null;
        this.size = 0;
    }

    @Override
    public E get(int index) {
        LinkedListNode<E> p = this.nodeAt(index);
        return p.getValue();
    }

    @Override
    public E set(int index, E value) {
        LinkedListNode<E> p = this.nodeAt(index);
        E old = p.getValue();
        p.setValue(value);
        return old;
    }

    private void rangeCheck(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
    }

    private LinkedListNode<E> nodeAt(int index) {
        LinkedListNode<E> p = this.head;
        int i = 0;
        this.rangeCheck(index);
        while (i < index) {
            ++i;
            p = p.getNext();
        }
        return p;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new LinkedListIterator<E>(this.head);
    }
}

