/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

public final class Int2D {
    private int rows;
    private int columns;
    private int[] data;

    public Int2D(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        this.data = new int[rows * columns];
    }

    public Int2D(int rows, int columns, int[] data) {
        this.rows = rows;
        this.columns = columns;
        this.data = data;
        if (data != null && data.length != rows * columns) {
            throw new IllegalArgumentException("Unmatched array size");
        }
        if (data == null) {
            this.data = new int[rows * columns];
        }
    }

    public int get(int r, int c) {
        return this.data[r * this.columns + c];
    }

    public void set(int r, int c, int v) {
        this.data[r * this.columns + c] = v;
    }

    public int length() {
        return this.data.length;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getLength(int rank) {
        switch (rank) {
            case 0: {
                return this.rows;
            }
            case 1: {
                return this.columns;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("int[");
        sb.append(this.rows);
        sb.append(", ");
        sb.append(this.columns);
        sb.append("]");
        return sb.toString();
    }
}

