/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.IBitEncoder;
import dev.fileformat.drako.RAnsBitEncoder;

class FoldedBit32Encoder
implements IBitEncoder {
    private RAnsBitEncoder[] folded_number_encoders_ = new RAnsBitEncoder[32];
    private RAnsBitEncoder bit_encoder_;

    public FoldedBit32Encoder() {
        for (int i = 0; i < this.folded_number_encoders_.length; ++i) {
            this.folded_number_encoders_[i] = new RAnsBitEncoder();
        }
        this.bit_encoder_ = new RAnsBitEncoder();
    }

    @Override
    public void startEncoding() {
        for (int i = 0; i < 32; ++i) {
            this.folded_number_encoders_[i].startEncoding();
        }
        this.bit_encoder_.startEncoding();
    }

    @Override
    public void encodeBit(boolean bit) {
        this.bit_encoder_.encodeBit(bit);
    }

    @Override
    public void encodeLeastSignificantBits32(int nbits, int value) {
        int selector = 1 << nbits - 1;
        for (int i = 0; i < nbits; ++i) {
            boolean bit = (value & selector) != 0;
            this.folded_number_encoders_[i].encodeBit(bit);
            selector >>= 1;
        }
    }

    @Override
    public void endEncoding(EncoderBuffer target_buffer) {
        for (int i = 0; i < 32; ++i) {
            this.folded_number_encoders_[i].endEncoding(target_buffer);
        }
        this.bit_encoder_.endEncoding(target_buffer);
    }

    @Override
    public void clear() {
        for (int i = 0; i < 32; ++i) {
            this.folded_number_encoders_[i].clear();
        }
        this.bit_encoder_.clear();
    }
}

