/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DracoEncodeOptions;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.RAnsSymbolEncoder;

class Encoding {
    static final int K_MAX_TAG_SYMBOL_BIT_LENGTH = 32;
    static final int K_MAX_RAW_ENCODING_BIT_LENGTH = 18;
    private static final int TAGGED = 0;
    private static final int RAW = 1;

    Encoding() {
    }

    public static void convertSignedIntsToSymbols(IntSpan input, int num, IntSpan output) {
        for (int i = 0; i < num; ++i) {
            boolean isNegative;
            int val = input.get(i);
            boolean bl = isNegative = val < 0;
            if (isNegative) {
                val = -val - 1;
            }
            val <<= 1;
            if (isNegative) {
                val |= 1;
            }
            output.put(i, val);
        }
    }

    public static int[] computeBitLengths(IntSpan symbols, int numComponents, int[] outMaxValue) {
        int[] outBitLengths = new int[symbols.size() / numComponents];
        int p = 0;
        outMaxValue[0] = 0;
        for (int i = 0; i < symbols.size(); i += numComponents) {
            int maxComponentValue = symbols.get(i);
            for (int j = 1; j < numComponents; ++j) {
                if (maxComponentValue >= symbols.get(i + j)) continue;
                maxComponentValue = symbols.get(i + j);
            }
            int valueMsbPos = 0;
            if (maxComponentValue > 0) {
                valueMsbPos = DracoUtils.mostSignificantBit(maxComponentValue);
            }
            if (maxComponentValue > outMaxValue[0]) {
                outMaxValue[0] = maxComponentValue;
            }
            outBitLengths[p++] = valueMsbPos + 1;
        }
        return outBitLengths;
    }

    static long computeShannonEntropy(IntSpan symbols, int num_symbols, int max_value, int[] out_num_unique_symbols) {
        int num_unique_symbols = 0;
        int[] symbol_frequencies = new int[max_value + 1];
        for (int i = 0; i < num_symbols; ++i) {
            int n = symbols.get(i);
            symbol_frequencies[n] = symbol_frequencies[n] + 1;
        }
        double total_bits = 0.0;
        double num_symbols_d = num_symbols;
        double log2 = Math.log(2.0);
        for (int i = 0; i < max_value + 1; ++i) {
            if (symbol_frequencies[i] <= 0) continue;
            ++num_unique_symbols;
            total_bits += (double)symbol_frequencies[i] * Math.log(1.0 * (double)symbol_frequencies[i] / num_symbols_d) / log2;
        }
        out_num_unique_symbols[0] = num_unique_symbols;
        return (long)(-total_bits);
    }

    static long approximateRAnsFrequencyTableBits(int max_value, int num_unique_symbols) {
        long table_zero_frequency_bits = 8 * (num_unique_symbols + (max_value - num_unique_symbols) / 64);
        return (long)(8 * num_unique_symbols) + table_zero_frequency_bits;
    }

    static long approximateTaggedSchemeBits(IntSpan bit_lengths, int num_components) {
        long total_bit_length = 0L;
        int[] ref0 = new int[1];
        for (int i = 0; i < bit_lengths.size(); ++i) {
            total_bit_length += (long)bit_lengths.get(i);
        }
        long tag_bits = Encoding.computeShannonEntropy(bit_lengths, bit_lengths.size(), 32, ref0);
        int num_unique_symbols = ref0[0];
        long tag_table_bits = Encoding.approximateRAnsFrequencyTableBits(num_unique_symbols, num_unique_symbols);
        return tag_bits + tag_table_bits + total_bit_length * (long)num_components;
    }

    static long approximateRawSchemeBits(IntSpan symbols, int num_symbols, int max_value, int[] out_num_unique_symbols) {
        int[] ref1 = new int[1];
        long data_bits = Encoding.computeShannonEntropy(symbols, num_symbols, max_value, ref1);
        int num_unique_symbols = ref1[0];
        long table_bits = Encoding.approximateRAnsFrequencyTableBits(max_value, num_unique_symbols);
        out_num_unique_symbols[0] = num_unique_symbols;
        return table_bits + data_bits;
    }

    public static void encodeSymbols(IntSpan symbols, int numValues, int numComponents, DracoEncodeOptions options, EncoderBuffer targetBuffer) throws DrakoException {
        int[] ref2 = new int[1];
        int[] ref3 = new int[1];
        if (symbols.size() == 0) {
            return;
        }
        if (numComponents == 0) {
            numComponents = 1;
        }
        int[] bitLengths = Encoding.computeBitLengths(symbols, numComponents, ref2);
        int maxValue = ref2[0];
        long tagged_scheme_total_bits = Encoding.approximateTaggedSchemeBits(IntSpan.wrap(bitLengths), numComponents);
        int num_unique_symbols = 0;
        long raw_scheme_total_bits = Encoding.approximateRawSchemeBits(symbols, numValues, maxValue, ref3);
        num_unique_symbols = ref3[0];
        int max_value_bit_length = DracoUtils.mostSignificantBit(Math.max(1, maxValue)) + 1;
        int method = options != null && options.getSymbolEncodingMethod() != null ? options.getSymbolEncodingMethod() : (tagged_scheme_total_bits < raw_scheme_total_bits || max_value_bit_length > 18 ? 0 : 1);
        targetBuffer.encode((byte)method);
        if (method == 0) {
            Encoding.encodeTaggedSymbols(symbols, numComponents, bitLengths, targetBuffer);
        } else if (method == 1) {
            Encoding.encodeRawSymbols(symbols, numValues, maxValue, num_unique_symbols, options, targetBuffer);
        } else {
            throw DracoUtils.failed();
        }
    }

    static boolean encodeTaggedSymbols(IntSpan symbols, int numComponents, int[] bitLengths, EncoderBuffer targetBuffer) {
        long[] frequencies = new long[32];
        for (int i = 0; i < bitLengths.length; ++i) {
            int n = bitLengths[i];
            frequencies[n] = frequencies[n] + 1L;
        }
        EncoderBuffer valueBuffer = new EncoderBuffer();
        int valueBits = 32 * symbols.size();
        RAnsSymbolEncoder tagEncoder = new RAnsSymbolEncoder(5, frequencies, targetBuffer);
        tagEncoder.startEncoding(targetBuffer);
        valueBuffer.startBitEncoding(valueBits, false);
        for (int i = symbols.size() - numComponents; i >= 0; i -= numComponents) {
            int bitLength = bitLengths[i / numComponents];
            tagEncoder.encodeSymbol(bitLength);
            int j = symbols.size() - numComponents - i;
            int valueBitLength = bitLengths[j / numComponents];
            for (int c = 0; c < numComponents; ++c) {
                valueBuffer.encodeLeastSignificantBits32(valueBitLength, symbols.get(j + c));
            }
        }
        tagEncoder.endEncoding(targetBuffer);
        valueBuffer.endBitEncoding();
        targetBuffer.encode(valueBuffer.getData(), valueBuffer.getBytes());
        return true;
    }

    static boolean encodeRawSymbols(IntSpan symbols, int num_values, int max_entry_value, int num_unique_symbols, DracoEncodeOptions options, EncoderBuffer target_buffer) {
        int unique_symbols_bit_length;
        int symbol_bits = 0;
        if (num_unique_symbols > 0) {
            symbol_bits = DracoUtils.mostSignificantBit(num_unique_symbols);
        }
        if ((unique_symbols_bit_length = symbol_bits + 1) > 18) {
            return false;
        }
        int compression_level = options.getCompressionLevel2();
        if (compression_level < 4) {
            unique_symbols_bit_length -= 2;
        } else if (compression_level < 6) {
            --unique_symbols_bit_length;
        } else if (compression_level > 9) {
            unique_symbols_bit_length += 2;
        } else if (compression_level > 7) {
            ++unique_symbols_bit_length;
        }
        unique_symbols_bit_length = Math.min(Math.max(1, unique_symbols_bit_length), 18);
        target_buffer.encode((byte)unique_symbols_bit_length);
        return Encoding.encodeRawSymbolsInternal(unique_symbols_bit_length, symbols, num_values, max_entry_value, target_buffer);
    }

    static boolean encodeRawSymbolsInternal(int unique_symbols_bit_length, IntSpan symbols, int num_values, int max_entry_value, EncoderBuffer target_buffer) {
        long[] frequencies = new long[max_entry_value + 1];
        for (int i = 0; i < num_values; ++i) {
            int n = symbols.get(i);
            frequencies[n] = frequencies[n] + 1L;
        }
        RAnsSymbolEncoder encoder = new RAnsSymbolEncoder(unique_symbols_bit_length, frequencies, target_buffer);
        encoder.startEncoding(target_buffer);
        boolean needsReverseEncoding = true;
        for (int i = num_values - 1; i >= 0; --i) {
            encoder.encodeSymbol(symbols.get(i));
        }
        encoder.endEncoding(target_buffer);
        return true;
    }

    static boolean encodeRawSymbols(IntSpan symbols, int maxValue, EncoderBuffer targetBuffer) {
        int maxValueBitLength;
        int maxEntryValue = maxValue;
        int maxValueBits = 0;
        if (maxEntryValue > 0) {
            maxValueBits = DracoUtils.mostSignificantBit(maxValue);
        }
        if ((maxValueBitLength = maxValueBits + 1) > 18) {
            return false;
        }
        targetBuffer.encode((byte)maxValueBitLength);
        long[] frequencies = new long[maxEntryValue + 1];
        for (int i = 0; i < symbols.size(); ++i) {
            int n = symbols.get(i);
            frequencies[n] = frequencies[n] + 1L;
        }
        RAnsSymbolEncoder encoder = new RAnsSymbolEncoder(maxValueBitLength, frequencies, targetBuffer);
        encoder.startEncoding(targetBuffer);
        for (int i = symbols.size() - 1; i >= 0; --i) {
            encoder.encodeSymbol(symbols.get(i));
        }
        encoder.endEncoding(targetBuffer);
        return true;
    }

    public static boolean encodeVarint(long val, EncoderBuffer buffer) {
        byte out_ = 0;
        out_ = (byte)(out_ | (byte)(val & 0x7FL));
        if (val >= 128L) {
            if (!buffer.encode(out_ = (byte)(out_ | 0xFFFFFF80))) {
                return false;
            }
            return Encoding.encodeVarint(val >>> 7, buffer);
        }
        return buffer.encode(out_);
    }

    public static boolean encodeVarint(int val, EncoderBuffer buffer) {
        return Encoding.encodeVarint2(val, buffer);
    }

    public static boolean encodeVarint2(int val, EncoderBuffer buffer) {
        byte out_ = 0;
        out_ = (byte)(out_ | (byte)(val & 0x7F));
        if ((0xFFFFFFFFL & (long)val) >= 128L) {
            if (!buffer.encode(out_ = (byte)(out_ | 0xFFFFFF80))) {
                return false;
            }
            return Encoding.encodeVarint(val >>> 7, buffer);
        }
        return buffer.encode(out_);
    }
}

