/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DirectBitEncoder;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.FoldedBit32Encoder;
import dev.fileformat.drako.HashBuilder;
import dev.fileformat.drako.IBitEncoder;
import dev.fileformat.drako.RAnsBitEncoder;
import dev.fileformat.drako.Struct;
import java.io.Serializable;
import java.util.Stack;

class DynamicIntegerPointsKdTreeEncoder {
    private int compression_level_t;
    int bit_length_;
    int num_points_;
    int dimension_;
    IBitEncoder numbers_encoder_;
    private IBitEncoder remaining_bits_encoder_;
    private IBitEncoder axis_encoder_;
    private IBitEncoder half_encoder_;
    int[] deviations_;
    int[] num_remaining_bits_;
    int[] axes_;
    int[][] base_stack_;
    int[][] levels_stack_;

    public DynamicIntegerPointsKdTreeEncoder(int compression_level, int dimension) {
        int i;
        this.$initFields$();
        this.compression_level_t = compression_level;
        this.dimension_ = dimension;
        this.deviations_ = new int[dimension];
        this.num_remaining_bits_ = new int[dimension];
        this.axes_ = new int[dimension];
        this.base_stack_ = new int[32 * dimension + 1][];
        for (i = 0; i < this.base_stack_.length; ++i) {
            this.base_stack_[i] = new int[dimension];
        }
        this.levels_stack_ = new int[32 * dimension + 1][];
        for (i = 0; i < this.levels_stack_.length; ++i) {
            this.levels_stack_[i] = new int[dimension];
        }
        this.numbers_encoder_ = this.createNumbersEncoder();
    }

    private IBitEncoder createNumbersEncoder() {
        switch (this.compression_level_t) {
            case 0: 
            case 1: {
                return new DirectBitEncoder();
            }
            case 2: 
            case 3: {
                return new RAnsBitEncoder();
            }
            case 4: 
            case 5: 
            case 6: {
                return new FoldedBit32Encoder();
            }
        }
        throw new IllegalStateException("Invalid compression level");
    }

    public void encodePoints(int[][] array, int bit_length, EncoderBuffer buffer) {
        this.bit_length_ = bit_length;
        this.num_points_ = array.length;
        buffer.encode(this.bit_length_);
        buffer.encode2(this.num_points_);
        if (this.num_points_ == 0) {
            return;
        }
        this.numbers_encoder_.startEncoding();
        this.remaining_bits_encoder_.startEncoding();
        this.axis_encoder_.startEncoding();
        this.half_encoder_.startEncoding();
        this.encodeInternal(array);
        this.numbers_encoder_.endEncoding(buffer);
        this.remaining_bits_encoder_.endEncoding(buffer);
        this.axis_encoder_.endEncoding(buffer);
        this.half_encoder_.endEncoding(buffer);
    }

    public void encodeNumber(int nbits, int value) {
        this.numbers_encoder_.encodeLeastSignificantBits32(nbits, value);
    }

    public int getAndEncodeAxis(int[][] array, int begin, int end, int[] old_base, int[] levels, int last_axis) {
        boolean select_axis;
        boolean bl = select_axis = this.compression_level_t == 6;
        if (!select_axis) {
            return DracoUtils.incrementMod(last_axis, this.dimension_);
        }
        int best_axis = 0;
        if (array.length < 64) {
            for (int axis = 1; axis < this.dimension_; ++axis) {
                if ((0xFFFFFFFFL & (long)levels[best_axis]) <= (0xFFFFFFFFL & (long)levels[axis])) continue;
                best_axis = axis;
            }
        } else {
            int size = array.length;
            for (int i = 0; i < this.dimension_; ++i) {
                this.deviations_[i] = 0;
                this.num_remaining_bits_[i] = this.bit_length_ - levels[i];
                if ((0xFFFFFFFFL & (long)this.num_remaining_bits_[i]) <= 0L) continue;
                int split = old_base[i] + (1 << this.num_remaining_bits_[i] - 1);
                int deviation = 0;
                int it = 0;
                while ((long)it < (0xFFFFFFFFL & (long)size)) {
                    if (array[it][i] < split) {
                        ++deviation;
                    }
                    ++it;
                }
                this.deviations_[i] = Math.max(size - deviation, deviation);
            }
            int max_value = 0;
            best_axis = 0;
            for (int i = 0; i < this.dimension_; ++i) {
                if ((0xFFFFFFFFL & (long)this.num_remaining_bits_[i]) == 0L || (0xFFFFFFFFL & (long)max_value) >= (0xFFFFFFFFL & (long)this.deviations_[i])) continue;
                max_value = this.deviations_[i];
                best_axis = i;
            }
            this.axis_encoder_.encodeLeastSignificantBits32(4, best_axis);
        }
        return best_axis;
    }

    void encodeInternal(int[][] array) {
        this.base_stack_[0] = new int[this.dimension_];
        this.levels_stack_[0] = new int[this.dimension_];
        EncodingStatus init_status = new EncodingStatus(0, array.length, 0, 0);
        Stack<EncodingStatus> status_stack = new Stack<EncodingStatus>();
        status_stack.push(Struct.byVal(init_status));
        while (!status_stack.isEmpty()) {
            boolean left;
            EncodingStatus status = (EncodingStatus)status_stack.peek();
            status_stack.pop();
            int begin = status.begin;
            int end = status.end;
            int last_axis = status.last_axis;
            int stack_pos = status.stack_pos;
            int[] old_base = this.base_stack_[stack_pos];
            int[] levels = this.levels_stack_[stack_pos];
            int axis = this.getAndEncodeAxis(array, begin, end, old_base, levels, last_axis);
            int level = levels[axis];
            int num_remaining_points = end - begin;
            if (this.bit_length_ - level == 0) continue;
            if (num_remaining_points <= 2) {
                this.axes_[0] = axis;
                int i = 1;
                while ((0xFFFFFFFFL & (long)i) < (long)this.dimension_) {
                    this.axes_[i] = DracoUtils.incrementMod(this.axes_[i - 1], this.dimension_);
                    ++i;
                }
                i = 0;
                while ((0xFFFFFFFFL & (long)i) < (long)num_remaining_points) {
                    int[] p = array[begin + i];
                    int j = 0;
                    while ((0xFFFFFFFFL & (long)j) < (long)this.dimension_) {
                        int num_remaining_bits = this.bit_length_ - levels[this.axes_[j]];
                        if (num_remaining_bits != 0) {
                            this.remaining_bits_encoder_.encodeLeastSignificantBits32(num_remaining_bits, p[this.axes_[j]]);
                        }
                        ++j;
                    }
                    ++i;
                }
                continue;
            }
            int modifier = 1 << this.bit_length_ - level - 1;
            System.arraycopy(old_base, 0, this.base_stack_[stack_pos + 1], 0, old_base.length);
            int[] nArray = this.base_stack_[stack_pos + 1];
            int n = axis;
            nArray[n] = nArray[n] + modifier;
            int[] new_base = this.base_stack_[stack_pos + 1];
            int split = this.partition(array, begin, end, axis, new_base[axis]);
            int required_bits = DracoUtils.mostSignificantBit(num_remaining_points);
            int first_half = split - begin;
            int second_half = end - split;
            boolean bl = left = first_half < second_half;
            if (first_half != second_half) {
                this.half_encoder_.encodeBit(left);
            }
            if (left) {
                this.encodeNumber(required_bits, num_remaining_points / 2 - first_half);
            } else {
                this.encodeNumber(required_bits, num_remaining_points / 2 - second_half);
            }
            int[] nArray2 = this.levels_stack_[stack_pos];
            int n2 = axis;
            nArray2[n2] = nArray2[n2] + 1;
            System.arraycopy(this.levels_stack_[stack_pos], 0, this.levels_stack_[stack_pos + 1], 0, this.dimension_);
            if (split != begin) {
                status_stack.push(new EncodingStatus(begin, split, axis, stack_pos));
            }
            if (split == end) continue;
            status_stack.push(new EncodingStatus(split, end, axis, stack_pos + 1));
        }
    }

    private int partition(int[][] points, int first, int last, int axis, int v) {
        while (first != last) {
            if ((long)points[first][axis] < (0xFFFFFFFFL & (long)v)) {
                ++first;
                continue;
            }
            do {
                if (first != --last) continue;
                return first;
            } while ((long)points[last][axis] >= (0xFFFFFFFFL & (long)v));
            int[] t = points[first];
            points[first] = points[last];
            points[last] = t;
            ++first;
        }
        return first;
    }

    private void $initFields$() {
        try {
            this.remaining_bits_encoder_ = new DirectBitEncoder();
            this.axis_encoder_ = new DirectBitEncoder();
            this.half_encoder_ = new DirectBitEncoder();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static final class EncodingStatus
    implements Struct<EncodingStatus>,
    Serializable {
        public int begin;
        public int end;
        public int last_axis;
        public int num_remaining_points;
        public int stack_pos;
        static final long serialVersionUID = -1528942074L;

        public EncodingStatus(int begin, int end, int last_axis_, int stack_pos_) {
            this.begin = begin;
            this.end = end;
            this.last_axis = last_axis_;
            this.stack_pos = stack_pos_;
            this.num_remaining_points = end - begin;
        }

        public EncodingStatus() {
        }

        private EncodingStatus(EncodingStatus other) {
            this.begin = other.begin;
            this.end = other.end;
            this.last_axis = other.last_axis;
            this.num_remaining_points = other.num_remaining_points;
            this.stack_pos = other.stack_pos;
        }

        @Override
        public EncodingStatus clone() {
            return new EncodingStatus(this);
        }

        @Override
        public void copyFrom(EncodingStatus src) {
            if (src == null) {
                return;
            }
            this.begin = src.begin;
            this.end = src.end;
            this.last_axis = src.last_axis;
            this.num_remaining_points = src.num_remaining_points;
            this.stack_pos = src.stack_pos;
        }

        public int hashCode() {
            HashBuilder builder = new HashBuilder();
            builder.hash(this.begin);
            builder.hash(this.end);
            builder.hash(this.last_axis);
            builder.hash(this.num_remaining_points);
            builder.hash(this.stack_pos);
            return builder.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EncodingStatus)) {
                return false;
            }
            EncodingStatus rhs = (EncodingStatus)obj;
            if (this.begin != rhs.begin) {
                return false;
            }
            if (this.end != rhs.end) {
                return false;
            }
            if (this.last_axis != rhs.last_axis) {
                return false;
            }
            if (this.num_remaining_points != rhs.num_remaining_points) {
                return false;
            }
            return this.stack_pos == rhs.stack_pos;
        }
    }
}

