/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.BitDecoder;
import dev.fileformat.drako.BitUtils;
import dev.fileformat.drako.BytePointer;
import dev.fileformat.drako.Decoding;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.Struct;
import dev.fileformat.drako.Unsafe;

final class DecoderBuffer {
    private final BitDecoder bitDecoder = new BitDecoder();
    private boolean bitMode = false;
    private int pos;
    private int length;
    private BytePointer data = new BytePointer();
    private byte[] tmp;
    private int bitstreamVersion;

    public int getBitstreamVersion() {
        return this.bitstreamVersion;
    }

    public void setBitstreamVersion(int value) {
        this.bitstreamVersion = value;
    }

    public DecoderBuffer(byte[] data) {
        this.$initFields$();
        this.initialize(new BytePointer(data), data.length);
    }

    private DecoderBuffer(BytePointer data, int length) {
        this.$initFields$();
        this.initialize(data, length);
    }

    public DecoderBuffer() {
        this.$initFields$();
    }

    public boolean getBitDecoderActive() {
        return this.bitMode;
    }

    public void copyFrom(DecoderBuffer src) {
        this.bitDecoder.copyFrom(src.bitDecoder);
        this.bitMode = src.bitMode;
        this.pos = src.pos;
        this.length = src.length;
        this.data.copyFrom(src.data);
        this.setBitstreamVersion(src.getBitstreamVersion());
    }

    public DecoderBuffer clone() {
        DecoderBuffer ret = new DecoderBuffer();
        ret.copyFrom(this);
        return ret;
    }

    private void initialize(BytePointer data, int length) {
        this.pos = 0;
        this.bitMode = false;
        this.data.copyFrom(data);
        this.length = length;
    }

    public int getRemainingSize() {
        return this.length - this.pos;
    }

    public DecoderBuffer subBuffer(int offset) {
        int length = this.length - this.pos - offset;
        DecoderBuffer ret = new DecoderBuffer(BytePointer.add(this.data, this.pos + offset), length);
        ret.setBitstreamVersion(this.getBitstreamVersion());
        return ret;
    }

    public int getDecodedSize() {
        return this.pos;
    }

    public int getBufferSize() {
        return this.length;
    }

    public BytePointer getPointer() {
        return Struct.byVal(this.data);
    }

    public void advance(int bytes) {
        this.pos += bytes;
    }

    public long startBitDecoding(boolean decodeSize) throws DrakoException {
        long outSize = 0L;
        if (decodeSize) {
            long n;
            outSize = this.getBitstreamVersion() < 22 ? this.decodeI64() : (n = Decoding.decodeVarintU64(this));
        }
        this.bitMode = true;
        this.bitDecoder.load(BytePointer.add(this.data, this.pos), this.length - this.pos);
        return outSize;
    }

    public void endBitDecoding() {
        this.bitMode = false;
        int bitsDecoded = this.bitDecoder.getBitsDecoded();
        int bytesDecoded = (bitsDecoded + 7) / 8;
        this.pos += bytesDecoded;
    }

    public boolean decode(byte[] buf, int len) {
        return this.decode(buf, 0, len);
    }

    public boolean decode(int[] values) {
        int bytes = values.length * 4;
        if (!this.remainingIsEnough(bytes)) {
            return false;
        }
        int n = this.data.getOffset() + this.pos;
        byte[] buf = this.data.getBaseData();
        for (int i = 0; i < values.length; ++i) {
            values[i] = Unsafe.getLE32(buf, n);
            n += 4;
            this.pos += 4;
        }
        return true;
    }

    public boolean decode(float[] floats) {
        int bytes = floats.length * 4;
        if (bytes >= this.tmp.length) {
            this.tmp = new byte[bytes];
        }
        if (!this.decode(this.tmp, bytes)) {
            return false;
        }
        Unsafe.toFloatArray(this.tmp, floats);
        return true;
    }

    public boolean decode(byte[] buf) {
        return this.decode(buf, 0, buf.length);
    }

    public boolean decode(byte[] buf, int start, int len) {
        if (!this.remainingIsEnough(len)) {
            return false;
        }
        this.data.copy(this.pos, buf, start, len);
        this.pos += len;
        return true;
    }

    public float decodeF32() throws DrakoException {
        if (!this.decode(this.tmp, 4)) {
            throw DracoUtils.failed();
        }
        return BitUtils.getFloat(this.tmp, 0);
    }

    public byte decodeI8() throws DrakoException {
        return this.decodeU8();
    }

    public byte decodeU8() throws DrakoException {
        if (!this.remainingIsEnough(1)) {
            throw DracoUtils.failed();
        }
        byte val = this.data.get(this.pos);
        ++this.pos;
        return val;
    }

    public short decodeU16() throws DrakoException {
        if (!this.remainingIsEnough(2)) {
            throw DracoUtils.failed();
        }
        short val = this.data.toUInt16LE(this.pos);
        this.pos += 2;
        return val;
    }

    public long decodeI64() throws DrakoException {
        if (!this.remainingIsEnough(8)) {
            throw DracoUtils.failed();
        }
        long val = this.data.toUInt64LE(this.pos);
        this.pos += 8;
        return val;
    }

    public int decodeU32() throws DrakoException {
        return this.decodeI32();
    }

    public int decodeI32() throws DrakoException {
        if (!this.remainingIsEnough(4)) {
            throw DracoUtils.failed();
        }
        int val = this.data.toUInt32LE(this.pos);
        this.pos += 4;
        return val;
    }

    private boolean remainingIsEnough(int size) {
        return this.length >= this.pos + size;
    }

    public boolean peek(byte[] result, int size) {
        if (this.data.isOverflow(this.pos + size)) {
            return false;
        }
        this.data.copy(this.pos, result, 0, size);
        return true;
    }

    public boolean decodeLeastSignificantBits32(int nbits, int[] value) {
        if (!this.bitMode) {
            value[0] = 0;
            return false;
        }
        value[0] = this.bitDecoder.getBits(nbits);
        return true;
    }

    public String toString() {
        int preview = Math.min(16, this.getRemainingSize());
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("0x%04x ", this.pos + this.data.getOffset()));
        int i = 0;
        int p = this.pos;
        while (i < preview) {
            sb.append(String.format("%02x ", this.data.get(p)));
            ++i;
            ++p;
        }
        int rest = this.getRemainingSize() - preview;
        if (rest > 0) {
            sb.append(String.format("...(%d bytes rest)", rest));
        }
        sb.append(String.format(", pos = %d", this.pos));
        return sb.toString();
    }

    private void $initFields$() {
        try {
            this.tmp = new byte[8];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

