/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.BitUtils;
import dev.fileformat.drako.Internal;
import dev.fileformat.drako.Stream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;

@Internal
class BinaryWriter
implements Closeable,
DataOutput {
    private Stream out;
    private Charset charset;
    private byte[] writeBuffer = new byte[8];
    private CharsetEncoder encoder;
    private CharBuffer charBuffer = CharBuffer.allocate(1);
    private ByteBuffer wrappedBuffer = ByteBuffer.wrap(this.writeBuffer);

    public BinaryWriter(Stream stream) {
        this(stream, StandardCharsets.UTF_8);
    }

    public BinaryWriter(Stream stream, Charset charset) {
        this.out = stream;
        this.charset = charset;
        this.encoder = charset.newEncoder();
    }

    public Stream getBaseStream() {
        return this.out;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void write(int n) throws IOException {
        this.out.writeByte(n);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.writeBuffer[0] = (byte)(v >>> 0);
        this.writeBuffer[1] = (byte)(v >>> 8);
        this.out.write(this.writeBuffer, 0, 2);
    }

    @Override
    public void writeChar(int v) throws IOException {
        BinaryWriter.clear(this.charBuffer);
        this.charBuffer.put((char)v);
        BinaryWriter.flip(this.charBuffer);
        BinaryWriter.clear(this.wrappedBuffer);
        this.encoder.encode(this.charBuffer, this.wrappedBuffer, false);
        BinaryWriter.flip(this.wrappedBuffer);
        this.writeBytes(this.wrappedBuffer);
    }

    private void write(ByteBuffer buf) throws IOException {
        int offset = buf.arrayOffset() + buf.position();
        int len = buf.limit();
        byte[] arr = buf.array();
        this.out.write(arr, offset, len);
    }

    @Override
    public void writeInt(int v) throws IOException {
        BitUtils.toBytes(this.writeBuffer, 0, v);
        this.out.write(this.writeBuffer, 0, 4);
    }

    @Override
    public void writeLong(long v) throws IOException {
        BitUtils.toBytes(this.writeBuffer, 0, v);
        this.out.write(this.writeBuffer, 0, 8);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.out.writeByte((byte)s.charAt(i));
        }
    }

    public void writeBytes(ByteBuffer s) throws IOException {
        int len = s.limit();
        int offset = s.arrayOffset();
        byte[] array = s.array();
        this.out.write(array, offset, len);
    }

    private void writeLEB128(int value) throws IOException {
        if (value == 0) {
            this.writeByte(0);
            return;
        }
        int pos = 0;
        byte[] buf = this.writeBuffer;
        while (value != 0) {
            buf[pos++] = (byte)(value & 0x7F | 0x80);
            value >>= 7;
        }
        int n = pos - 1;
        buf[n] = (byte)(buf[n] & 0x7F);
        this.write(buf, 0, pos);
    }

    @Override
    public void writeChars(String s) throws IOException {
        ByteBuffer buf = this.encoder.encode(CharBuffer.wrap(s));
        this.writeLEB128(s.length());
        this.writeBytes(buf);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.writeChars(s);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    private static void clear(Buffer buffer) {
        buffer.clear();
    }

    private static void flip(Buffer buffer) {
        buffer.flip();
    }
}

