/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.IOUtils;
import dev.fileformat.drako.Internal;
import dev.fileformat.drako.Stream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;

@Internal
class BinaryReader
implements Closeable,
DataInput {
    private Stream stream;
    private byte[] buf = new byte[8];
    private Charset charset;
    private ByteBuffer byteBuffer;
    private CharBuffer charBuffer;
    private CharsetDecoder decoder;
    private int maxBytesPerChar;

    public BinaryReader(Stream stream) {
        this(stream, StandardCharsets.UTF_8);
    }

    public BinaryReader(Stream stream, Charset charset) {
        this.stream = stream;
        this.charset = charset;
    }

    public Stream getBaseStream() {
        return this.stream;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.stream.read(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        int offset = off;
        int rest = len;
        while (rest > 0) {
            int bytesRead = this.read(b, offset, len);
            if (bytesRead == 0 && rest > 0) {
                throw new IOException("Insufficient data to read.");
            }
            rest -= bytesRead;
            offset += bytesRead;
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.stream.seek(n, 1);
        return 0;
    }

    private void fillBuffer(int bytes) throws IOException {
        this.readFully(this.buf, 0, bytes);
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.fillBuffer(1);
        return this.buf[0] != 0;
    }

    @Override
    public byte readByte() throws IOException {
        this.fillBuffer(1);
        return this.buf[0];
    }

    public byte[] readBytes(int size) throws IOException {
        byte[] ret = new byte[size];
        this.stream.read(ret);
        return ret;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.fillBuffer(1);
        return this.buf[0] & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        this.fillBuffer(2);
        return (short)(this.buf[1] << 8 | this.buf[0] & 0xFF);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.fillBuffer(2);
        return (this.buf[1] & 0xFF) << 8 | this.buf[0] & 0xFF;
    }

    private void initDecoder() {
        if (this.decoder != null) {
            return;
        }
        this.decoder = this.charset.newDecoder();
        this.maxBytesPerChar = (int)this.charset.newEncoder().maxBytesPerChar();
        this.byteBuffer = ByteBuffer.allocate(this.maxBytesPerChar);
        this.charBuffer = CharBuffer.allocate(10);
    }

    @Override
    public char readChar() throws IOException {
        this.initDecoder();
        IOUtils.clear(this.byteBuffer);
        IOUtils.position(this.byteBuffer, 0);
        IOUtils.clear(this.charBuffer);
        byte[] tmp = this.byteBuffer.array();
        for (int i = 0; i < this.maxBytesPerChar; ++i) {
            tmp[i] = this.readByte();
            IOUtils.limit(this.byteBuffer, i + 1);
            this.decoder.decode(this.byteBuffer, this.charBuffer, false);
            if (this.charBuffer.position() != 1) continue;
            IOUtils.flip(this.charBuffer);
            return this.charBuffer.get();
        }
        return '\uffff';
    }

    @Override
    public int readInt() throws IOException {
        this.fillBuffer(4);
        return (this.buf[3] & 0xFF) << 24 | (this.buf[2] & 0xFF) << 16 | (this.buf[1] & 0xFF) << 8 | this.buf[0] & 0xFF;
    }

    @Override
    public long readLong() throws IOException {
        this.fillBuffer(8);
        return (long)(this.buf[7] & 0xFF) << 56 | (long)(this.buf[6] & 0xFF) << 48 | (long)(this.buf[5] & 0xFF) << 40 | (long)(this.buf[4] & 0xFF) << 32 | (long)(this.buf[3] & 0xFF) << 24 | (long)(this.buf[2] & 0xFF) << 16 | (long)(this.buf[1] & 0xFF) << 8 | (long)(this.buf[0] & 0xFF);
    }

    @Override
    public float readFloat() throws IOException {
        int n = this.readInt();
        return Float.intBitsToFloat(n);
    }

    @Override
    public double readDouble() throws IOException {
        long n = this.readLong();
        return Double.longBitsToDouble(n);
    }

    @Override
    public String readLine() throws IOException {
        throw new RuntimeException("Not implemented");
    }

    private int readLEB128() throws IOException {
        byte b;
        int result = 0;
        int shift = 0;
        do {
            b = this.readByte();
            result |= (b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        return result;
    }

    @Override
    public String readUTF() throws IOException {
        int len = this.readLEB128();
        char[] ret = new char[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readChar();
        }
        return new String(ret);
    }

    @Override
    public void close() throws IOException {
    }
}

