/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.fnnbs;

import java.util.Objects;

public class Note {
    private int instrument;
    private int key;
    private int velocity;
    private int panning;
    private int pitch;

    public Note(int instrument, int key, int velocity, int panning, int pitch) {
        this.instrument = instrument;
        this.key = key;
        this.velocity = velocity;
        this.panning = panning;
        this.pitch = pitch;
    }

    public int getInstrument() {
        return this.instrument;
    }

    public int getKey() {
        return this.key;
    }

    public int getPanning() {
        return this.panning;
    }

    public int getPitch() {
        return this.pitch;
    }

    public int getVelocity() {
        return this.velocity;
    }

    public float getRawVelocity() {
        return (float)this.velocity / 100.0f;
    }

    public void setInstrument(int instrument) {
        this.instrument = instrument;
    }

    public void setKey(int key) {
        this.key = key;
    }

    public void setPanning(int panning) {
        this.panning = panning;
    }

    public void setPitch(int pitch) {
        this.pitch = pitch;
    }

    public void setVelocity(int velocity) {
        this.velocity = velocity;
    }

    public String toString() {
        return "Note{instrument=" + this.instrument + ", key=" + this.key + ", velocity=" + this.velocity + ", panning=" + this.panning + ", pitch=" + this.pitch + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Note note = (Note)o;
        return this.instrument == note.instrument && this.key == note.key && this.velocity == note.velocity && this.panning == note.panning && this.pitch == note.pitch;
    }

    public int hashCode() {
        return Objects.hash(this.instrument, this.key, this.velocity, this.panning, this.pitch);
    }
}

