/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.fnnbs.player;

import dev.felnull.fnnbs.InstrumentNote;
import dev.felnull.fnnbs.Layer;
import dev.felnull.fnnbs.NBS;
import dev.felnull.fnnbs.Note;
import dev.felnull.fnnbs.player.INBSPlayerImpl;
import java.util.List;

public class NBSPlayer {
    private final NBS nbs;
    private final INBSPlayerImpl impl;
    private int tick;
    private boolean loop;
    private boolean forcedLoop;

    public NBSPlayer(NBS nbs, INBSPlayerImpl impl) {
        this.nbs = nbs;
        this.impl = impl;
    }

    public NBS getNBS() {
        return this.nbs;
    }

    public boolean tick() {
        if (this.getNBS().getLength() <= this.tick) {
            return false;
        }
        List<Layer> layers = this.nbs.getLayers();
        for (Layer layer : layers) {
            Note note = layer.getNote(this.tick);
            if (note == null || !(note instanceof InstrumentNote)) continue;
            InstrumentNote in = (InstrumentNote)note;
            float vol = in.getRawVelocity() * layer.getRawVolume();
            float dfkey = in.getNoteInstrument().getDefaultPitch() - 45.0f;
            float pitch = (float)Math.pow(2.0, (double)((float)(in.getKey() - 45) + dfkey) / 12.0);
            float stereo = (float)layer.getStereo() / 100.0f - 1.0f;
            this.impl.play(in.getNoteInstrument(), vol, pitch, stereo);
        }
        ++this.tick;
        if (this.loop && this.getNBS().isLoop() && this.getNBS().getLength() <= this.tick || this.forcedLoop) {
            this.tick = this.getNBS().getLoopStart();
        }
        return true;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public void setForcedLoop(boolean forcedLoop) {
        this.forcedLoop = forcedLoop;
    }
}

