/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.fnnbs.player;

import dev.felnull.fnnbs.NBS;
import dev.felnull.fnnbs.player.INBSPlayerImpl;
import dev.felnull.fnnbs.player.NBSPlayer;

public class AsyncNBSPlayer
extends NBSPlayer {
    private PlayerThread playerThread;
    private String playThreadName;

    public AsyncNBSPlayer(NBS nbs, INBSPlayerImpl impl) {
        super(nbs, impl);
    }

    public void setPlayThreadName(String playThreadName) {
        this.playThreadName = playThreadName;
    }

    public void playStart() {
        if (this.isPlaying()) {
            return;
        }
        this.playerThread = new PlayerThread();
        if (this.playThreadName != null) {
            this.playerThread.setName(this.playThreadName);
        }
        this.playerThread.start();
    }

    public void playStop() {
        if (!this.isPlaying()) {
            return;
        }
        this.playerThread.interrupt();
        this.playerThread = null;
    }

    public boolean isPlaying() {
        return this.playerThread != null && this.playerThread.isAlive();
    }

    private class PlayerThread
    extends Thread {
        private PlayerThread() {
        }

        @Override
        public void run() {
            while (!this.isInterrupted() && AsyncNBSPlayer.this.tick()) {
                long tickSpeed = (long)(1000.0f / ((float)AsyncNBSPlayer.this.getNBS().getTempo() / 100.0f));
                try {
                    Thread.sleep(tickSpeed);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

