/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.fnnbs;

import dev.felnull.fnnbs.InstrumentNote;
import dev.felnull.fnnbs.Layer;
import dev.felnull.fnnbs.Note;
import dev.felnull.fnnbs.instrument.CustomInstrument;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NBS {
    private boolean old;
    private int version;
    private int vanillaInstrumentCount;
    private int length;
    private String name;
    private String author;
    private String originalAuthor;
    private String description;
    private int tempo;
    private boolean autoSaving;
    private int autoSavingDuration;
    private int timeSignature;
    private int minutesSpent;
    private int leftClicks;
    private int rightClicks;
    private int noteBlocksAdded;
    private int noteBlocksRemoved;
    private String importFileName;
    private boolean loop;
    private int loopCount;
    private int loopStart;
    private final List<Layer> layers = new ArrayList<Layer>();
    private final List<CustomInstrument> customInstruments = new ArrayList<CustomInstrument>();

    public NBS() {
    }

    public NBS(InputStream stream) throws IOException {
        int fl = this.readShort(stream);
        boolean bl = this.old = fl != 0;
        if (this.old) {
            this.length = fl;
        } else {
            this.version = stream.read();
            this.vanillaInstrumentCount = stream.read();
            this.length = this.readShort(stream);
        }
        int layerCount = this.readShort(stream);
        for (int i = 0; i < layerCount; ++i) {
            this.layers.add(new Layer());
        }
        this.name = this.readString(stream);
        this.author = this.readString(stream);
        this.originalAuthor = this.readString(stream);
        this.description = this.readString(stream);
        this.tempo = this.readShort(stream);
        this.autoSaving = this.readBoolean(stream);
        this.autoSavingDuration = stream.read();
        this.timeSignature = stream.read();
        this.minutesSpent = this.readInt(stream);
        this.leftClicks = this.readInt(stream);
        this.rightClicks = this.readInt(stream);
        this.noteBlocksAdded = this.readInt(stream);
        this.noteBlocksRemoved = this.readInt(stream);
        this.importFileName = this.readString(stream);
        if (!this.old) {
            this.loop = this.readBoolean(stream);
            this.loopCount = stream.read();
            this.loopStart = this.readShort(stream);
        }
        int tick = -1;
        int nextJT = this.readShort(stream);
        while (nextJT != 0) {
            tick += nextJT;
            int layer = -1;
            int nextJL = this.readShort(stream);
            while (nextJL != 0) {
                layer += nextJL;
                int instrument = stream.read();
                int key = stream.read();
                int velocity = this.old ? 100 : stream.read();
                int panning = this.old ? 100 : stream.read();
                int pitch = this.old ? 0 : this.readSignedShort(stream);
                Note note = new Note(instrument, key, velocity, panning, pitch);
                this.layers.get(layer).addNote(tick, note);
                nextJL = this.readShort(stream);
            }
            nextJT = this.readShort(stream);
        }
        for (int i = 0; i < this.getLayerCount(); ++i) {
            this.layers.get(i).setName(this.readString(stream));
            this.layers.get(i).setLock(this.readBoolean(stream));
            this.layers.get(i).setVolume(stream.read());
            this.layers.get(i).setStereo(stream.read());
        }
        int cic = stream.read();
        if (cic != -1) {
            for (int i = 0; i < cic; ++i) {
                this.customInstruments.add(new CustomInstrument(this.readString(stream), this.readString(stream), stream.read(), this.readBoolean(stream)));
            }
        }
        for (Layer layer : this.layers) {
            Map<Integer, Note> notes = layer.getNotes();
            notes.replaceAll((k, v) -> new InstrumentNote(this, (Note)v));
        }
    }

    private int readSignedShort(InputStream stream) throws IOException {
        return stream.read() + (stream.read() << 8);
    }

    private boolean readBoolean(InputStream stream) throws IOException {
        return stream.read() >= 1;
    }

    private String readString(InputStream stream) throws IOException {
        byte[] dat = new byte[this.readInt(stream)];
        stream.read(dat);
        return new String(dat, StandardCharsets.UTF_8);
    }

    private int readInt(InputStream stream) throws IOException {
        return stream.read() + (stream.read() << 8) + (stream.read() << 16) + (stream.read() << 24);
    }

    private int readShort(InputStream stream) throws IOException {
        return stream.read() + (stream.read() << 8);
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public int getAutoSavingDuration() {
        return this.autoSavingDuration;
    }

    public int getLayerCount() {
        return this.layers.size();
    }

    public int getLeftClicks() {
        return this.leftClicks;
    }

    public int getLength() {
        return this.length + 1;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public int getLoopStart() {
        return this.loopStart;
    }

    public int getMinutesSpent() {
        return this.minutesSpent;
    }

    public int getNoteBlocksAdded() {
        return this.noteBlocksAdded;
    }

    public int getNoteBlocksRemoved() {
        return this.noteBlocksRemoved;
    }

    public int getRightClicks() {
        return this.rightClicks;
    }

    public int getTempo() {
        return this.tempo;
    }

    public int getTimeSignature() {
        return this.timeSignature;
    }

    public int getVanillaInstrumentCount() {
        return this.vanillaInstrumentCount;
    }

    public int getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getImportFileName() {
        return this.importFileName;
    }

    public String getOriginalAuthor() {
        return this.originalAuthor;
    }

    public boolean isAutoSaving() {
        return this.autoSaving;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public boolean isOld() {
        return this.old;
    }

    public float getRawTempo() {
        return (float)this.getTempo() / 100.0f;
    }

    public long getTicksPerSecond() {
        return (long)(1000.0f / this.getRawTempo());
    }

    public long getLoopStartSecond() {
        return 50L * (long)this.getLoopStart();
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setAutoSaving(boolean autoSaving) {
        this.autoSaving = autoSaving;
    }

    public void setAutoSavingDuration(int autoSavingDuration) {
        this.autoSavingDuration = autoSavingDuration;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setImportFileName(String importFileName) {
        this.importFileName = importFileName;
    }

    public void setLeftClicks(int leftClicks) {
        this.leftClicks = leftClicks;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public void setLoopCount(int loopCount) {
        this.loopCount = loopCount;
    }

    public void setLoopStart(int loopStart) {
        this.loopStart = loopStart;
    }

    public void setMinutesSpent(int minutesSpent) {
        this.minutesSpent = minutesSpent;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNoteBlocksAdded(int noteBlocksAdded) {
        this.noteBlocksAdded = noteBlocksAdded;
    }

    public void setNoteBlocksRemoved(int noteBlocksRemoved) {
        this.noteBlocksRemoved = noteBlocksRemoved;
    }

    public void setOld(boolean old) {
        this.old = old;
    }

    public void setOriginalAuthor(String originalAuthor) {
        this.originalAuthor = originalAuthor;
    }

    public void setRightClicks(int rightClicks) {
        this.rightClicks = rightClicks;
    }

    public void setTempo(int tempo) {
        this.tempo = tempo;
    }

    public void setTimeSignature(int timeSignature) {
        this.timeSignature = timeSignature;
    }

    public void setVanillaInstrumentCount(int vanillaInstrumentCount) {
        this.vanillaInstrumentCount = vanillaInstrumentCount;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Layer getLayer(int num) {
        return this.layers.get(num);
    }

    public void addLayer(Layer layer) {
        this.layers.add(layer);
    }

    public int getCustomInstrumentCount() {
        return this.customInstruments.size();
    }

    public List<CustomInstrument> getCustomInstruments() {
        return this.customInstruments;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public String toString() {
        return "NBS{old=" + this.old + ", version=" + this.version + ", vanillaInstrumentCount=" + this.vanillaInstrumentCount + ", length=" + this.length + ", name='" + this.name + '\'' + ", author='" + this.author + '\'' + ", originalAuthor='" + this.originalAuthor + '\'' + ", description='" + this.description + '\'' + ", tempo=" + this.tempo + ", autoSaving=" + this.autoSaving + ", autoSavingDuration=" + this.autoSavingDuration + ", timeSignature=" + this.timeSignature + ", minutesSpent=" + this.minutesSpent + ", leftClicks=" + this.leftClicks + ", rightClicks=" + this.rightClicks + ", noteBlocksAdded=" + this.noteBlocksAdded + ", noteBlocksRemoved=" + this.noteBlocksRemoved + ", importFileName='" + this.importFileName + '\'' + ", loop=" + this.loop + ", loopCount=" + this.loopCount + ", loopStart=" + this.loopStart + ", layers=" + this.layers + ", customInstruments=" + this.customInstruments + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBS nbs = (NBS)o;
        return this.old == nbs.old && this.version == nbs.version && this.vanillaInstrumentCount == nbs.vanillaInstrumentCount && this.length == nbs.length && this.tempo == nbs.tempo && this.autoSaving == nbs.autoSaving && this.autoSavingDuration == nbs.autoSavingDuration && this.timeSignature == nbs.timeSignature && this.minutesSpent == nbs.minutesSpent && this.leftClicks == nbs.leftClicks && this.rightClicks == nbs.rightClicks && this.noteBlocksAdded == nbs.noteBlocksAdded && this.noteBlocksRemoved == nbs.noteBlocksRemoved && this.loop == nbs.loop && this.loopCount == nbs.loopCount && this.loopStart == nbs.loopStart && Objects.equals(this.name, nbs.name) && Objects.equals(this.author, nbs.author) && Objects.equals(this.originalAuthor, nbs.originalAuthor) && Objects.equals(this.description, nbs.description) && Objects.equals(this.importFileName, nbs.importFileName) && Objects.equals(this.layers, nbs.layers) && Objects.equals(this.customInstruments, nbs.customInstruments);
    }

    public int hashCode() {
        return Objects.hash(this.old, this.version, this.vanillaInstrumentCount, this.length, this.name, this.author, this.originalAuthor, this.description, this.tempo, this.autoSaving, this.autoSavingDuration, this.timeSignature, this.minutesSpent, this.leftClicks, this.rightClicks, this.noteBlocksAdded, this.noteBlocksRemoved, this.importFileName, this.loop, this.loopCount, this.loopStart, this.layers, this.customInstruments);
    }
}

