/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice;

import dev.equo.solstice.Solstice;
import dev.equo.solstice.SolsticeManifest;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Optional;
import org.osgi.framework.Bundle;
import org.osgi.framework.connect.FrameworkUtilHelper;

public class SolsticeFrameworkUtilHelper
implements FrameworkUtilHelper {
    private static Solstice owner;

    public static void initialize(Solstice owner) {
        SolsticeFrameworkUtilHelper.owner = owner;
    }

    public Optional<Bundle> getBundle(Class<?> classFromBundle) {
        if (owner == null) {
            return Optional.empty();
        }
        ProtectionDomain domain = classFromBundle.getProtectionDomain();
        CodeSource source = domain.getCodeSource();
        if (source == null) {
            return Optional.of(owner.getContext().getBundle(0L));
        }
        URL location = source.getLocation();
        SolsticeManifest manifest = owner.bundleForUrl(location);
        if (manifest == null) {
            return Optional.of(owner.getContext().getBundle(0L));
        }
        if (manifest.isFragment()) {
            manifest = owner.bundleForSymbolicName(manifest.fragmentHost());
        }
        return Optional.of(manifest.hydrated);
    }
}

