/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice;

import dev.equo.solstice.ShimBundle;
import dev.equo.solstice.ShimBundleRevision;
import dev.equo.solstice.Unimplemented;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

class ShimBundleWiring
extends Unimplemented.BundleWiring {
    private final ShimBundle bundle;

    ShimBundleWiring(ShimBundle bundle) {
        this.bundle = Objects.requireNonNull(bundle);
    }

    @Override
    public List<BundleWire> getRequiredWires(String namespace) {
        if (namespace.equals("osgi.wiring.host") && this.bundle.manifest.isFragment()) {
            final ShimBundle host = this.bundle.getRootBundleContext().bundleForSymbolicName(this.bundle.manifest.fragmentHost());
            return Collections.singletonList(new Unimplemented.BundleWire(){

                @Override
                public BundleWiring getProviderWiring() {
                    return host.adapt(BundleWiring.class);
                }
            });
        }
        return Collections.emptyList();
    }

    @Override
    public BundleRevision getRevision() {
        return new ShimBundleRevision(this.bundle);
    }

    @Override
    public Collection<String> listResources(String path, String filePattern, int options) {
        boolean recurse = (options & 1) == 1;
        ShimBundle.Finder finder = new ShimBundle.Finder(path, filePattern, recurse);
        ArrayList<URL> urls = new ArrayList<URL>();
        HashSet<String> alreadySearched = new HashSet<String>();
        ArrayDeque<ShimBundle> toSearch = new ArrayDeque<ShimBundle>();
        toSearch.add(this.bundle);
        alreadySearched.add(this.bundle.manifest.getSymbolicName());
        while (!toSearch.isEmpty()) {
            finder.addEntriesIn(urls, (ShimBundle)toSearch.poll());
            for (String required : this.bundle.manifest.totalRequiredBundles()) {
                if (alreadySearched.add(required)) continue;
                toSearch.add(this.bundle.getRootBundleContext().bundleForSymbolicName(required));
            }
        }
        ArrayList<String> strings = new ArrayList<String>(urls.size());
        for (URL url : urls) {
            strings.add(url.toExternalForm());
        }
        return strings;
    }

    @Override
    public boolean isInUse() {
        return true;
    }

    @Override
    public List<BundleWire> getProvidedWires(String namespace) {
        return Collections.emptyList();
    }

    @Override
    public ClassLoader getClassLoader() {
        return ShimBundleWiring.class.getClassLoader();
    }
}

