/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice.p2;

import dev.equo.solstice.p2.Unchecked;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class CacheLocations {
    private static File ideWorkspaces = null;
    public static File override_ideWorkspaces = null;
    private static final String P2_DATA_WITHIN_M2 = "repository/dev/equo/p2-data/";
    private static final String P2_DATA_GRADLE_USER_HOME = "caches/p2-data";
    private static File p2data = null;
    public static File override_p2data = null;

    private CacheLocations() {
    }

    private static Path userHome() {
        return new File(System.getProperty("user.home")).toPath();
    }

    public static File ideWorkspaces() {
        if (ideWorkspaces == null && (ideWorkspaces = override_ideWorkspaces) == null) {
            ideWorkspaces = CacheLocations.userHome().resolve(".equo").resolve("ide-workspaces").toFile();
        }
        return ideWorkspaces;
    }

    public static File p2data() {
        if (p2data == null && (p2data = override_p2data) == null) {
            try {
                Path m2 = CacheLocations.userHome().resolve(".m2");
                if (!Files.exists(m2, new LinkOption[0])) {
                    Files.createDirectories(m2, new FileAttribute[0]);
                }
                Path p2Data = m2.resolve(P2_DATA_WITHIN_M2);
                p2data = p2Data.resolve("repository/dev/equo/p2-data").toFile();
            }
            catch (Exception e) {
                String gradleUserHome = System.getenv("GRADLE_USER_HOME");
                if (gradleUserHome == null) {
                    throw Unchecked.wrap(e);
                }
                p2data = new File(gradleUserHome).toPath().resolve(P2_DATA_GRADLE_USER_HOME).toFile();
            }
        }
        return p2data;
    }

    static File p2Queries() {
        return new File(CacheLocations.p2data(), "queries");
    }

    static File p2metadata() {
        return new File(CacheLocations.p2data(), "metadata");
    }

    static File p2bundlePool() {
        return new File(CacheLocations.p2data(), "bundle-pool");
    }

    public static File p2nestedJars() {
        return new File(CacheLocations.p2data(), "nested-jars");
    }
}

