/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.tools;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Settings {
    private HashMap<String, String> settings;
    private Path storage;

    public Settings(Path saveIn) {
        if (!Files.exists(saveIn, LinkOption.NOFOLLOW_LINKS)) {
            if (saveIn.getParent() != null) {
                try {
                    Files.createDirectories(saveIn.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                this.storage = Files.createFile(saveIn, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.storage = saveIn;
        }
        try {
            List<String> list = Files.readAllLines(this.storage);
            this.settings = new HashMap(list.size());
            list.forEach(s -> {
                String[] parts;
                if (!s.startsWith("#") && (parts = s.split("=")).length == 2) {
                    this.settings.put(parts[0], parts[1]);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getOrDefault(String property, String defaultValue) {
        String value = this.settings.get(property);
        if (value != null) {
            return value;
        }
        this.put(property, defaultValue);
        return defaultValue;
    }

    public String put(String property, String value) {
        return this.settings.put(property, value);
    }

    public void save() {
        ArrayList entries = new ArrayList(this.settings.size());
        this.settings.forEach((s, s2) -> entries.add(s + "=" + s2));
        try {
            Files.write(this.storage, entries, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

