/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.tools;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.text.Text;

public class Methods {
    public static Path createFile(Path path, LinkOption ... linkOptions) {
        if (!Files.exists(path, linkOptions)) {
            if (path.getParent() != null) {
                try {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                Files.createFile(path, new FileAttribute[0]);
                return path;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            return path;
        }
        return null;
    }

    public static Path copyFile(Path from, Path to, CopyOption ... copyOptions) {
        try {
            if (to.getParent() != null) {
                Files.createDirectories(to.getParent(), new FileAttribute[0]);
            }
            return Files.copy(from, to, copyOptions);
        }
        catch (IOException e) {
            e.printStackTrace();
            return to;
        }
    }

    public static List<String> readFile(Path path) {
        try {
            return Files.readAllLines(path, Charset.defaultCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Path write(Path path, Iterable<? extends CharSequence> charSequences) {
        try {
            return Files.write(path, charSequences, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean delete(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            List<Path> files = Methods.getFiles(path, new ArrayList<Path>());
            for (Path path2 : files) {
                Methods.delete(path2);
            }
            List<Path> folders = Methods.getDirectories(path, new ArrayList<Path>());
            Collections.reverse(folders);
            for (Path directory : folders) {
                try {
                    if (!Files.isWritable(directory)) continue;
                    Files.deleteIfExists(directory);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            try {
                return Files.deleteIfExists(path);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }
        try {
            if (Files.isWritable(path)) {
                return Files.deleteIfExists(path);
            }
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static List<Path> getFiles(Path from, List<Path> list) {
        if (Files.isDirectory(from, new LinkOption[0])) {
            if (Files.isReadable(from)) {
                try {
                    Stream<Path> pathStream = Files.list(from);
                    List<Path> paths = pathStream.collect(Collectors.toList());
                    paths.forEach(path -> {
                        if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
                            Methods.getFiles(path, list);
                        } else {
                            list.add((Path)path);
                        }
                    });
                    pathStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            throw new IllegalArgumentException(from + " is not a directory");
        }
        return list;
    }

    public static List<Path> getDirectories(Path from, List<Path> list) {
        if (Files.isDirectory(from, new LinkOption[0])) {
            if (Files.isReadable(from)) {
                list.add(from);
                try {
                    Stream<Path> pathStream = Files.list(from);
                    List<Path> paths = pathStream.collect(Collectors.toList());
                    paths.forEach(path -> {
                        if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
                            Methods.getDirectories(path, list);
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            throw new IllegalArgumentException(from + " is not a directory");
        }
        return list;
    }

    public static double getVisualTextWidth(String string) {
        Text text = new Text(string);
        new Scene((Parent)new Group(new Node[]{text}));
        text.applyCss();
        return text.getLayoutBounds().getWidth();
    }

    public static HashMap<String, String> createMapFrom(String ... strings) {
        HashMap<String, String> hashMap = new HashMap<String, String>(strings.length);
        for (String string : strings) {
            String[] pair;
            if (!string.contains(":") || (pair = string.split(":")).length != 2) continue;
            hashMap.put(pair[0], pair[1]);
        }
        return hashMap;
    }

    public static String removeAllCharactersFrom(String target, String ... toRemove) {
        for (String s : toRemove) {
            if (s.length() > 1) continue;
            target = target.replaceAll(Pattern.quote(s), "");
        }
        return target;
    }

    public static <I> List<I> newList(I ... items) {
        ArrayList arrayList = new ArrayList(items.length);
        Collections.addAll(arrayList, items);
        return arrayList;
    }
}

