/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.parser.excel;

import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.parser.excel.ExcelCell;
import java.util.Iterator;

public class ExcelRow
implements Iterable<ExcelCell> {
    private SimpleList<ExcelCell> children;

    public int getRowPos() {
        if (this.size() > 0) {
            return this.first().getReferenz().y;
        }
        return -1;
    }

    private ExcelCell first() {
        if (this.children == null) {
            return null;
        }
        return (ExcelCell)this.children.first();
    }

    public ExcelCell getItem(int index) {
        for (int i = 0; i < this.size(); ++i) {
            ExcelCell cell = this.get(i);
            if (cell == null || cell.getReferenz().x != index) continue;
            return cell;
        }
        return new ExcelCell();
    }

    public ExcelCell get(int index) {
        return (ExcelCell)this.children.get(index);
    }

    public SimpleList<ExcelCell> getChildren() {
        return this.children;
    }

    public int size() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public boolean add(ExcelCell ... values) {
        if (values == null) {
            return false;
        }
        if (this.children == null) {
            this.children = new SimpleList();
        }
        boolean result = true;
        for (ExcelCell item : values) {
            result = this.children.add(item) && result;
        }
        return true;
    }

    @Override
    public Iterator<ExcelCell> iterator() {
        if (this.children == null) {
            this.children = new SimpleList();
        }
        return this.children.iterator();
    }

    public ExcelRow with(ExcelCell ... values) {
        if (values == null) {
            return this;
        }
        if (this.children == null) {
            this.children = new SimpleList();
        }
        for (ExcelCell cell : values) {
            this.children.with(new Object[]{cell});
        }
        return this;
    }
}

