/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.json;

import de.uniks.networkparser.Filter;
import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.UpdateCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.UpdateListener;
import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.list.SimpleIteratorSet;
import de.uniks.networkparser.list.SimpleKeyValueList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class UpdateJson
implements PropertyChangeListener {
    private IdMap map;
    private ArrayList<String> suspendIdList;
    private Filter updateFilter = new Filter().withStrategy("upd").withConvertable(new UpdateCondition());

    public UpdateJson(IdMap map) {
        this.map = map;
    }

    public JsonObject garbageCollection(Object root) {
        if (root == null) {
            return null;
        }
        JsonObject initField = this.map.toJsonObject(root);
        ArrayList<String> classCounts = new ArrayList<String>();
        SimpleKeyValueList<String, Object> gc = new SimpleKeyValueList<String, Object>();
        this.countMessage(initField, classCounts, gc);
        for (String id : classCounts) {
            if (!this.map.hasKey(id)) continue;
            this.map.removeObj(this.map.getObject(id), false);
        }
        return initField;
    }

    public void suspendNotification() {
        this.suspendIdList = new ArrayList();
    }

    public void resetNotification() {
        JsonArray array = this.map.getJsonByIds(this.suspendIdList);
        if (array.size() > 0) {
            JsonObject message = new JsonObject();
            message.put("upd", array);
            this.map.notify(new SimpleEvent("new", message, this.map, null, null, null));
        }
        this.suspendIdList = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        this.updateFilter.withPropertyRegard(this.map.getListener());
        if (oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        Object source = evt.getSource();
        String propertyName = evt.getPropertyName();
        SendableEntityCreator creatorClass = this.map.getCreatorClass(source);
        if (creatorClass == null) {
            return;
        }
        boolean done = false;
        for (String attrName : creatorClass.getProperties()) {
            if (!attrName.equals(propertyName)) continue;
            done = true;
            break;
        }
        if (!done) {
            if ("REMOVE_YOU".equals(propertyName)) {
                this.removeObj(evt.getOldValue(), true);
            }
            return;
        }
        JsonObject jsonObject = new JsonObject().withValue("class", source.getClass().getName()).withValue("id", this.map.getId(source));
        if (oldValue != null) {
            creatorClass = this.map.getCreatorClass(oldValue);
            JsonObject child = new JsonObject();
            if (creatorClass != null) {
                String oldId = this.map.getId(oldValue);
                if (oldId != null) {
                    child.put(propertyName, new JsonObject().withValue("id", oldId));
                }
            } else {
                child.put(propertyName, oldValue);
            }
            jsonObject.put("rem", child);
        }
        if (newValue != null) {
            creatorClass = this.map.getCreatorClass(newValue);
            JsonObject child = new JsonObject();
            if (creatorClass != null) {
                JsonObject item;
                String key = this.map.getKey(newValue);
                if (key != null) {
                    item = new JsonObject().withValue("class", newValue.getClass().getName()).withValue("id", key);
                    child.put(propertyName, item);
                } else {
                    item = this.map.toJsonObject(newValue, this.updateFilter);
                    child.put(propertyName, item);
                    if (this.suspendIdList != null) {
                        this.suspendIdList.add(this.map.getId(newValue));
                    }
                }
            } else {
                child.put(propertyName, newValue);
            }
            jsonObject.put("upd", child);
        }
        if (this.map.getCounter().getPrio() != null) {
            jsonObject.put("prio", this.map.getCounter().getPrio());
        }
        if (this.suspendIdList == null) {
            this.map.notify(new SimpleEvent("new", jsonObject, evt, this.map));
        }
    }

    public Object execute(JsonObject updateMessage) {
        return this.execute(updateMessage, new Filter());
    }

    public Object execute(JsonObject updateMessage, Filter filter) {
        Object refObject;
        SendableEntityCreator creator;
        String masterObjClassName;
        if (!updateMessage.has("upd") && !updateMessage.has("rem")) {
            return null;
        }
        String id = updateMessage.getString("id");
        JsonObject remove = (JsonObject)updateMessage.get("rem");
        JsonObject update = (JsonObject)updateMessage.get("upd");
        Object prio = updateMessage.get("prio");
        Object masterObj = this.map.getObject(id);
        if (masterObj == null && (masterObjClassName = (String)updateMessage.get("class")) != null && (masterObj = (creator = this.map.getCreator(masterObjClassName, true)).getSendableInstance(false)) != null) {
            this.map.put(id, masterObj);
        }
        if (masterObj == null) {
            return null;
        }
        SendableEntityCreator creator2 = this.map.getCreatorClass(masterObj);
        if (remove == null && update != null) {
            refObject = creator2.getSendableInstance(true);
            SimpleIteratorSet<String, Object> i = new SimpleIteratorSet<String, Object>(update);
            while (i.hasNext()) {
                Object item = i.next();
                String key = (String)item.getKey();
                Object value = creator2.getValue(masterObj, key);
                if (value == null) {
                    return this.setValue(creator2, masterObj, key, item.getValue(), "new");
                }
                if (value.equals(creator2.getValue(refObject, key))) {
                    return this.setValue(creator2, masterObj, key, update.get(key), "new");
                }
                if (!this.checkPrio(prio)) continue;
                return this.setValue(creator2, masterObj, key, update.get(key), "collision");
            }
            return true;
        }
        if (update == null && remove != null) {
            refObject = creator2.getSendableInstance(true);
            Iterator keys = remove.keyIterator();
            while (keys.hasNext()) {
                JsonObject removeJsonObject;
                String key = (String)keys.next();
                Object value = creator2.getValue(masterObj, key);
                if (value instanceof Collection) {
                    removeJsonObject = remove.getJsonObject(key);
                    this.setValue(creator2, masterObj, key, removeJsonObject, "rem");
                } else if (this.checkValue(value, key, remove)) {
                    this.setValue(creator2, masterObj, key, creator2.getValue(refObject, key), "rem");
                } else if (this.checkPrio(prio)) {
                    this.setValue(creator2, masterObj, key, creator2.getValue(refObject, key), "rem");
                }
                if ((removeJsonObject = remove.get(key)) == null || !(removeJsonObject instanceof JsonObject)) continue;
                JsonObject json = removeJsonObject;
                this.map.notify(new SimpleEvent("rem", json, this.map, key, this.map.decode(json), null).withModelValue(masterObj));
            }
            return masterObj;
        }
        if (update != null) {
            Iterator keys = update.keyIterator();
            while (keys.hasNext()) {
                Object newValue;
                String key = (String)keys.next();
                Object oldValue = creator2.getValue(masterObj, key);
                if (this.checkValue(oldValue, key, remove)) {
                    newValue = update.get(key);
                    this.setValue(creator2, masterObj, key, newValue, "upd");
                    this.map.notify(new SimpleEvent("upd", update, this.map, key, oldValue, newValue).withModelValue(masterObj));
                    continue;
                }
                if (!this.checkPrio(prio)) continue;
                newValue = update.get(key);
                this.setValue(creator2, masterObj, key, newValue, "upd");
                this.map.notify(new SimpleEvent("upd", update, this.map, key, oldValue, newValue).withModelValue(masterObj));
            }
            return masterObj;
        }
        return null;
    }

    private boolean checkValue(Object value, String key, JsonObject oldJsonObject) {
        if (value != null) {
            Object oldValue = oldJsonObject.get(key);
            if (oldValue instanceof JsonObject) {
                String oldId = (String)((JsonObject)oldValue).get("id");
                return oldId.equals(this.map.getId(value));
            }
            if (oldValue.equals(value)) {
                return true;
            }
        }
        return false;
    }

    private boolean checkPrio(Object prio) {
        Object myPrio = this.map.getCounter().getPrio();
        if (prio != null && myPrio != null) {
            if (prio instanceof Integer && myPrio instanceof Integer) {
                Integer ref = (Integer)myPrio;
                return ref.compareTo((Integer)prio) > 0;
            }
            if (prio instanceof String && myPrio instanceof String) {
                String ref = (String)myPrio;
                return ref.compareTo((String)prio) > 0;
            }
        } else if (myPrio == null) {
            return true;
        }
        return false;
    }

    private Object setValue(SendableEntityCreator creator, Object element, String key, Object newValue, String typ) {
        if (newValue instanceof JsonObject) {
            JsonObject json = (JsonObject)newValue;
            Object value = this.map.decode(json);
            if (value != null) {
                creator.setValue(element, key, value, typ);
                if (this.map.notify(new SimpleEvent(typ, json, this.map, key, null, value).withModelValue(element))) {
                    return element;
                }
            }
        } else {
            creator.setValue(element, key, newValue, typ);
            if (this.map.notify(new SimpleEvent(typ, null, this.map, key, null, newValue).withModelValue(element))) {
                return element;
            }
        }
        return null;
    }

    public UpdateJson withReguardFilter(UpdateListener filter) {
        this.updateFilter.withPropertyRegard(filter);
        return this;
    }

    private void countMessage(JsonObject message, ArrayList<String> classCounts, SimpleKeyValueList<String, Object> gc) {
        if (message.has("id")) {
            String id = (String)message.get("id");
            if (gc.containsKey(id)) {
                gc.put(id, (Integer)gc.getValue(id) + 1);
            } else {
                gc.put(id, 1);
            }
            if (message.has("class")) {
                if (classCounts.contains(id)) {
                    return;
                }
                classCounts.add(id);
                JsonObject props = (JsonObject)message.get("prop");
                for (int i = 0; i < props.size(); ++i) {
                    if (props.getValueByIndex(i) instanceof JsonObject) {
                        this.countMessage((JsonObject)props.getValueByIndex(i), classCounts, gc);
                        continue;
                    }
                    if (!(props.getValueByIndex(i) instanceof JsonArray)) continue;
                    this.countMessage((JsonArray)props.getValueByIndex(i), classCounts, gc);
                }
            }
        }
    }

    private void countMessage(JsonArray message, ArrayList<String> classCounts, SimpleKeyValueList<String, Object> gc) {
        for (Object obj : message) {
            if (!(obj instanceof JsonObject)) continue;
            this.countMessage((JsonObject)obj, classCounts, gc);
        }
    }

    public boolean removeObj(Object oldValue, boolean destroy) {
        if (this.map != null) {
            return this.map.removeObj(oldValue, destroy);
        }
        return false;
    }
}

