/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.StringFilter;

public class Modifier
extends GraphMember {
    public static final StringFilter<Modifier> NAME = new StringFilter("name");
    public static final Modifier PUBLIC = new Modifier("public");
    public static final Modifier PACKAGE = new Modifier("");
    public static final Modifier PROTECTED = new Modifier("protected");
    public static final Modifier PRIVATE = new Modifier("private");
    public static final Modifier FINAL = new Modifier("final");
    public static final Modifier ABSTRACT = new Modifier("abstract");
    public static final Modifier STATIC = new Modifier("static");

    Modifier(String value) {
        this.setName(value);
    }

    @Override
    public Modifier with(String name) {
        super.with(name);
        return this;
    }

    public static Modifier create(String value) {
        return new Modifier(value);
    }

    public static Modifier create(Modifier ... value) {
        Modifier mod = new Modifier("");
        for (Modifier item : value) {
            if (item.has(PUBLIC) || item.has(PACKAGE) || item.has(PROTECTED) || item.has(PRIVATE)) {
                mod.with(item.getName());
                continue;
            }
            mod.withChildren(item);
        }
        return mod;
    }

    public boolean has(Modifier other) {
        if (this.getName().equals(other.getName())) {
            return true;
        }
        if (this.children != null) {
            for (GraphMember member : this.getChildren()) {
                if (!(member instanceof Modifier) || !((Modifier)member).has(other)) continue;
                return true;
            }
        }
        return false;
    }

    public GraphMember getParent() {
        return (GraphMember)this.parentNode;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.hashCode() == this.hashCode()) {
            return true;
        }
        if (obj instanceof Modifier) {
            return this.has((Modifier)obj);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

