/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.graph.Annotation;
import de.uniks.networkparser.graph.Association;
import de.uniks.networkparser.graph.AssociationTypes;
import de.uniks.networkparser.graph.Attribute;
import de.uniks.networkparser.graph.Cardinality;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.GraphDiff;
import de.uniks.networkparser.graph.GraphEntity;
import de.uniks.networkparser.graph.GraphList;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.GraphSimpleSet;
import de.uniks.networkparser.graph.Method;
import de.uniks.networkparser.graph.Modifier;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.list.SimpleSet;

public class GraphUtil {
    public static Clazz getByObject(GraphEntity item, String clazz, boolean fullName) {
        if (clazz == null) {
            return null;
        }
        return (Clazz)item.getByObject(clazz, fullName);
    }

    public static SimpleSet<Annotation> getAnnotations(GraphMember item) {
        if (item == null) {
            return null;
        }
        SimpleSet<Annotation> collection = new SimpleSet<Annotation>();
        Annotation annotation = null;
        if (item instanceof Clazz) {
            annotation = ((Clazz)item).getAnnotation();
        }
        if (item instanceof Attribute) {
            annotation = ((Attribute)item).getAnnotation();
        }
        if (item instanceof Annotation) {
            annotation = (Annotation)item;
        }
        if (annotation != null) {
            collection.add(annotation);
            while (annotation.hasNext()) {
                annotation = annotation.next();
                collection.add(annotation);
            }
        }
        return collection;
    }

    public static boolean isWithNoObjects(Clazz clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz.getModifier().has(Modifier.ABSTRACT) || clazz.getType() == Clazz.ClazzType.INTERFACE;
    }

    public static boolean isInterface(Clazz clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz.getType() == Clazz.ClazzType.INTERFACE;
    }

    public static boolean isEnumeration(Clazz clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz.getType() == Clazz.ClazzType.ENUMERATION;
    }

    public static boolean isUndirectional(Association assoc) {
        if (assoc == null) {
            return false;
        }
        if (assoc.getType() == AssociationTypes.ASSOCIATION && assoc.getOtherType() == AssociationTypes.EDGE) {
            return true;
        }
        return assoc.getOtherType() == AssociationTypes.ASSOCIATION && assoc.getType() == AssociationTypes.EDGE;
    }

    public static boolean isInterfaceAssociation(Association assoc) {
        if (assoc == null) {
            return false;
        }
        if (assoc.getType() == AssociationTypes.IMPLEMENTS && assoc.getOtherType() == AssociationTypes.EDGE) {
            return true;
        }
        return assoc.getOtherType() == AssociationTypes.IMPLEMENTS && assoc.getType() == AssociationTypes.EDGE;
    }

    public static CharacterBuffer getMethodParameters(Method method, boolean shortName) {
        return method.getParameterString(shortName);
    }

    public static SimpleSet<Association> getOtherAssociations(Clazz clazz) {
        SimpleSet<Association> collection = new SimpleSet<Association>();
        for (Association assoc : clazz.getAssociations(new Condition[0])) {
            collection.add(assoc.getOther());
        }
        return collection;
    }

    public static GraphSimpleSet getChildren(GraphMember item) {
        return item.getChildren();
    }

    public static String getSeperator(Association item) {
        return item.getSeperator();
    }

    public static SimpleSet<GraphEntity> getNodes(GraphMember item) {
        return item.getNodes();
    }

    public static GraphDiff getDifference(GraphMember item) {
        return item.getDiff();
    }

    public static boolean addAccoc(GraphList list, Association assoc) {
        return list.addAssoc(assoc);
    }

    public static Attribute createAttribute() {
        return new Attribute();
    }

    public static void removeYou(GraphMember value) {
        if (value == null) {
            return;
        }
        value.setParent(null);
        if (value instanceof Attribute) {
            Attribute attribute = (Attribute)value;
            Annotation annotation = attribute.getAnnotation();
            value.without(annotation);
        }
        if (value instanceof Association) {
            Association assoc = (Association)value;
            assoc.withOther(null);
            assoc.without(assoc.getClazz());
        }
        if (value instanceof Clazz) {
            Clazz clazz = (Clazz)value;
            GraphSimpleSet collection = clazz.getChildren();
            clazz.without(collection.toArray(new GraphMember[collection.size()]));
        }
    }

    public static boolean containsClazzAssociation(SimpleList<GraphMember> visited, Association assoc, Association other) {
        boolean foundAssoc = false;
        for (GraphMember checkItem : visited) {
            Association assocA;
            Association assocB;
            if (!(checkItem instanceof Association) || checkItem.getName() == null || (assocB = (assocA = (Association)checkItem).getOther()).getName() == null || !assocA.getName().equals(assoc.getName()) || !assocB.getName().equals(other.getName())) continue;
            foundAssoc = true;
            if (assocA.getClazz() == assoc.getClazz()) {
                if (assocB.getClazz() == other.getClazz()) {
                    assocA.with(Cardinality.MANY);
                    assocB.with(Cardinality.MANY);
                    break;
                }
                assocA.with(Cardinality.MANY);
                break;
            }
            assocB.with(Cardinality.MANY);
            break;
        }
        return foundAssoc;
    }
}

