/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.UpdateListener;
import de.uniks.networkparser.list.SimpleSet;
import java.util.Set;

public class GraphPatternMatch
implements UpdateListener,
SendableEntityCreator {
    public static final String ITEM = "item";
    public static final String MATCHES = "matches";
    public static final String PROPERTY = "property";
    private Object item;
    private String property;
    private Set<UpdateListener> matches;

    @Override
    public boolean update(Object evt) {
        return true;
    }

    public Object getItem() {
        return this.item;
    }

    public GraphPatternMatch withItem(Object value) {
        this.item = value;
        return this;
    }

    public GraphPatternMatch with(UpdateListener ... value) {
        if (value == null) {
            return this;
        }
        for (UpdateListener listener : value) {
            if (listener == null) continue;
            if (this.matches == null) {
                this.matches = new SimpleSet<UpdateListener>();
            }
            this.matches.add(listener);
        }
        return this;
    }

    public Set<UpdateListener> getMatches() {
        return this.matches;
    }

    public GraphPatternMatch withProperty(String value) {
        this.property = value;
        return this;
    }

    public String getProperty() {
        return this.property;
    }

    @Override
    public String[] getProperties() {
        return new String[]{ITEM, PROPERTY, MATCHES};
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return new GraphPatternMatch();
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (ITEM.equalsIgnoreCase(attribute)) {
            return ((GraphPatternMatch)entity).getItem();
        }
        if (MATCHES.equalsIgnoreCase(attribute)) {
            return ((GraphPatternMatch)entity).getMatches();
        }
        if (PROPERTY.equalsIgnoreCase(attribute)) {
            return ((GraphPatternMatch)entity).getProperty();
        }
        return null;
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (ITEM.equalsIgnoreCase(attribute)) {
            ((GraphPatternMatch)entity).withItem(value);
            return true;
        }
        if (MATCHES.equalsIgnoreCase(attribute)) {
            if (value instanceof UpdateListener) {
                ((GraphPatternMatch)entity).with((UpdateListener)value);
            } else {
                ((GraphPatternMatch)entity).with((UpdateListener[])value);
            }
            return true;
        }
        if (PROPERTY.equalsIgnoreCase(attribute)) {
            ((GraphPatternMatch)entity).withProperty("" + value);
            return true;
        }
        return false;
    }

    public static GraphPatternMatch create(String property, Object item) {
        return new GraphPatternMatch().withItem(item);
    }

    public int size() {
        if (this.matches == null) {
            return 0;
        }
        int size = 0;
        for (UpdateListener child : this.matches) {
            if (child instanceof GraphPatternMatch) {
                size += ((GraphPatternMatch)child).size();
                continue;
            }
            ++size;
        }
        return size;
    }
}

