/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser;

import de.uniks.networkparser.interfaces.IdMapCounter;

public class SimpleIdCounter
implements IdMapCounter {
    protected String prefixId = "J1";
    protected long number = 1L;
    private char splitter = (char)46;
    private Object prio;

    public IdMapCounter withNumber(long number) {
        this.number = number;
        return this;
    }

    @Override
    public IdMapCounter withPrefixId(String value) {
        this.prefixId = value;
        return this;
    }

    @Override
    public String getPrefixId() {
        return this.prefixId;
    }

    @Override
    public String getId(Object obj) {
        if (obj == null) {
            return "";
        }
        String className = obj.getClass().getName();
        char firstChar = className.charAt(className.lastIndexOf(".") + 1);
        String key = this.prefixId != null ? this.prefixId + this.splitter + firstChar + this.number : "" + firstChar + this.number;
        ++this.number;
        return key;
    }

    @Override
    public void readId(String jsonId) {
        String key = null;
        if (this.prefixId != null) {
            String[] split = jsonId.split("\\" + this.splitter);
            key = split[split.length - 1];
        } else {
            key = jsonId;
        }
        if (key != null) {
            try {
                String oldNumber = key.substring(1);
                long oldInt = Long.parseLong(oldNumber);
                if (oldInt >= this.number) {
                    this.number = oldInt + 1L;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public char getSplitter() {
        return this.splitter;
    }

    @Override
    public IdMapCounter withSplitter(char splitter) {
        this.splitter = splitter;
        return this;
    }

    @Override
    public Object getPrio() {
        return this.prio;
    }

    public SimpleIdCounter withPrio(Object prio) {
        this.prio = prio;
        return this;
    }
}

