/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser;

import de.uniks.networkparser.Filter;
import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.buffer.Tokener;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.Grammar;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.SendableEntityCreatorTag;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.xml.MapEntityStack;

public class MapEntity
extends SimpleList<Object> {
    private Filter filter;
    private Grammar grammar;
    private int deep;
    private Object target;
    private MapEntityStack stack;
    private byte tokenerFlag;

    public MapEntity(Grammar grammar, String tag, Object item, SendableEntityCreator creator) {
        this.flag = 0;
        this.grammar = grammar;
        this.withStack(new MapEntityStack().withStack(tag, item, creator));
    }

    public MapEntity(Filter filter, Grammar grammar) {
        this.flag = 1;
        if (filter != null) {
            this.filter = filter;
        }
        this.grammar = grammar;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public Entity encode(Object entity, Tokener tokener) {
        return tokener.getMap().encode(entity, this, tokener);
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public void add() {
        ++this.deep;
    }

    public void minus() {
        --this.deep;
    }

    public int getDeep() {
        return this.deep;
    }

    public boolean isTypSave() {
        return (this.flag & 2) != 0;
    }

    public boolean isSearchForSuperClass() {
        return (this.flag & 4) != 0;
    }

    public SendableEntityCreator getCreator(String type, IdMap map, Object item, String className) {
        return this.grammar.getCreator(type, item, map, this.isSearchForSuperClass(), className);
    }

    public Object getNewEntity(SendableEntityCreator creator, String className, boolean prototype) {
        return this.grammar.getNewEntity(creator, className, prototype);
    }

    public boolean hasValue(Entity item, String property) {
        return this.grammar.hasValue(item, property);
    }

    public String getValue(Entity item, String property) {
        return this.grammar.getValue(item, property);
    }

    public BaseItem getProperties(Entity entity, IdMap map, boolean isId, String type) {
        return this.grammar.getProperties(entity, map, this.filter, isId, type);
    }

    public String getId(Object entity, IdMap map, String className) {
        if (this.filter.isId(entity, className, map)) {
            String id = map.getId(entity);
            this.with(new Object[]{id});
            return id;
        }
        this.with(new Object[]{entity});
        return null;
    }

    public boolean isFullSeriation() {
        return this.filter.isFullSeriation();
    }

    public String[] getProperties(Tokener tokener, SendableEntityCreator creator) {
        return this.filter.getProperties(creator);
    }

    public boolean isPropertyRegard(Object entity, IdMap map, String property, Object value) {
        return this.filter.isPropertyRegard(entity, property, value, map, this.deep);
    }

    public boolean isConvertable(Object entity, IdMap map, String property, Object value) {
        return this.filter.isConvertable(entity, property, value, map, this.deep);
    }

    public boolean isId(Object entity, IdMap map, String className) {
        return this.filter.isId(entity, className, map);
    }

    public String getStrategy() {
        return this.filter.getStrategy();
    }

    public Object getTarget() {
        return this.target;
    }

    public MapEntity withTarget(Object target) {
        this.target = target;
        return this;
    }

    public MapEntity withDeep(int value) {
        this.deep = value;
        return this;
    }

    public Object getRefByEntity(Object value) {
        for (int i = 0; i < this.size(); i += 2) {
            if (this.get(i) != value) continue;
            return this.get(i + 1);
        }
        return null;
    }

    public MapEntityStack getStack() {
        return this.stack;
    }

    public void pushStack(String className, Object entity, SendableEntityCreator creator) {
        if (this.stack != null) {
            this.stack.withStack(className, entity, creator);
        }
    }

    public void popStack() {
        if (this.stack != null) {
            this.stack.popStack();
        }
    }

    public MapEntity withStack(MapEntityStack stack) {
        this.stack = stack;
        return this;
    }

    public CharacterBuffer getPrefixProperties(SendableEntityCreator creator, Tokener tokener, Object entity, String className) {
        boolean isId = this.filter.isId(entity, className, tokener.getMap());
        return this.grammar.getPrefixProperties(creator, tokener, isId);
    }

    public Entity writeBasicValue(SendableEntityCreator creator, Entity entity, BaseItem parent, String className, String id) {
        if ((this.flag & 1) == 0) {
            if (creator instanceof SendableEntityCreatorTag) {
                className = ((SendableEntityCreatorTag)creator).getTag();
            }
            id = null;
        }
        return this.grammar.writeBasicValue(entity, parent, className, id, this);
    }

    public boolean isAddOwnerLink(Object value) {
        if ((this.flag & 1) != 0) {
            return true;
        }
        if (this.stack != null) {
            return this.stack.getPrevItem() != value;
        }
        return false;
    }

    public int getIndexOfClazz(String clazzName) {
        if (clazzName == null) {
            return -1;
        }
        int pos = 0;
        for (Object item : this) {
            if (clazzName.equalsIgnoreCase(item.getClass().getName())) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public int getIndexVisitedObjects(Object element) {
        int pos = 0;
        for (Object item : this) {
            if (item == element) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public Object getVisitedObjects(int index) {
        if (index >= 0 && index < this.size()) {
            return this.get(index);
        }
        return null;
    }

    public String getClazz(int pos) {
        if (pos < 0 || pos > this.size()) {
            return null;
        }
        Object item = this.get(pos);
        if (item instanceof String) {
            return "" + item;
        }
        return null;
    }

    public String getLastClazz() {
        Object item = this.last();
        if (item != null) {
            return item.getClass().getName();
        }
        return null;
    }

    @Override
    public MapEntity withFlag(byte flag) {
        this.flag = (byte)(this.flag | flag);
        return this;
    }

    public MapEntity withoutFlag(byte flag) {
        this.flag = (byte)(this.flag | flag);
        this.flag = (byte)(this.flag - flag);
        return this;
    }

    public Entity convertProperty(CharacterBuffer property, BaseItem parent) {
        BaseItem child = parent;
        while (property.charAt(0) == '.' && property.length() != 1) {
            int pos = property.indexOf(46, 1);
            if (pos < 0) {
                property.trimStart(1);
                break;
            }
            String label = property.substring(1, pos);
            property.trimStart(label.length() + 1);
            if (!(child instanceof Entity)) continue;
            BaseItem newItem = ((Entity)child).getChild(label, false);
            if (newItem == null) {
                newItem = child.getNewList(true);
                ((Entity)child).put(label, newItem);
            }
            child = newItem;
        }
        return (Entity)child;
    }

    public boolean isFlag(byte flag) {
        return (this.flag & flag) != 0;
    }

    public boolean writeValue(BaseItem parent, String property, Object value, Tokener tokener) {
        return this.grammar.writeValue(parent, property, value, this, tokener);
    }

    public MapEntity withTokenerFlag(byte flag) {
        this.tokenerFlag = (byte)(this.tokenerFlag | flag);
        return this;
    }

    public MapEntity withoutTokenerFlag(byte flag) {
        this.tokenerFlag = (byte)(this.tokenerFlag | flag);
        this.tokenerFlag = (byte)(this.tokenerFlag - flag);
        return this;
    }

    public boolean isTokenerFlag(byte flag) {
        return (this.tokenerFlag & flag) != 0;
    }
}

