/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.httputils;

@FunctionalInterface
public interface WaitStrategy {
    public int milliseconds(int var1);

    public static WaitStrategy exponentialBackoff() {
        return retry -> (int)(Math.random() * (Math.pow(2.0, retry) * 500.0));
    }

    public static WaitStrategy constant(int ms) {
        return retry -> ms;
    }

    public static WaitStrategy constant() {
        return WaitStrategy.constant(1000);
    }

    public static WaitStrategy linear(int ms) {
        return retry -> (retry + 1) * ms;
    }

    public static WaitStrategy linear() {
        return WaitStrategy.linear(1000);
    }
}

