/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.daemon.log4j;

import de.taimos.daemon.DaemonStarter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class JSONLayout
extends Layout {
    public void activateOptions() {
    }

    public String format(LoggingEvent event) {
        return this.createJSON(event);
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public String getContentType() {
        return "application/json";
    }

    private String createJSON(LoggingEvent event) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        HashMap<String, Object> log = new HashMap<String, Object>();
        log.put("daemon", DaemonStarter.getDaemonName());
        log.put("instance", DaemonStarter.getInstanceId());
        log.put("host", DaemonStarter.getHostname());
        log.put("phase", DaemonStarter.getCurrentPhase().name());
        log.put("timestamp", sdf.format(new Date(event.getTimeStamp())));
        log.put("level", event.getLevel().toString());
        log.put("source", event.getLoggerName());
        log.put("message", event.getRenderedMessage());
        log.put("thread", event.getThreadName());
        if (event.getThrowableInformation() != null) {
            Throwable throwable = event.getThrowableInformation().getThrowable();
            ArrayList<String> stacktrace = new ArrayList<String>();
            log.put("throwable", throwable.toString());
            for (StackTraceElement ste : throwable.getStackTrace()) {
                stacktrace.add(ste.toString());
            }
            log.put("stacktrace", stacktrace);
        }
        if (event.getProperties() != null) {
            log.put("mdc", event.getProperties());
        }
        StringBuilder sb = new StringBuilder();
        this.addObject(sb, log);
        sb.append(Layout.LINE_SEP);
        return sb.toString();
    }

    private void addObject(StringBuilder sb, Map<String, Object> map) {
        sb.append("{");
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        boolean first = true;
        for (Map.Entry<String, Object> entry : entrySet) {
            if (first) {
                first = false;
            } else {
                this.addSeparator(sb);
            }
            this.addField(sb, entry.getKey(), entry.getValue());
        }
        sb.append("}");
    }

    private void addField(StringBuilder sb, String field, Object value) {
        sb.append("\"");
        sb.append(this.cleanString(field));
        sb.append("\":");
        this.addValue(sb, value);
    }

    private void addSeparator(StringBuilder sb) {
        sb.append(",");
    }

    private void addArray(StringBuilder sb, Object ... values) {
        sb.append("[");
        for (int i = 0; i < values.length; ++i) {
            this.addValue(sb, values[i]);
            if (i == values.length - 1) continue;
            this.addSeparator(sb);
        }
        sb.append("]");
    }

    private void addValue(StringBuilder sb, Object value) {
        if (value instanceof String) {
            sb.append("\"");
            sb.append(this.cleanString((String)value));
            sb.append("\"");
        } else if (value instanceof Map) {
            this.addObject(sb, (Map)value);
        } else if (value instanceof Object[]) {
            this.addArray(sb, (Object[])value);
        } else if (value instanceof List) {
            this.addArray(sb, ((List)value).toArray());
        } else {
            throw new RuntimeException("Invalid value: " + value);
        }
    }

    private String cleanString(String value) {
        return value.replaceAll("\"", "");
    }
}

