/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.junit5;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import de.softwareforge.testing.postgres.embedded.DatabaseInfo;
import de.softwareforge.testing.postgres.embedded.DatabaseManager;
import de.softwareforge.testing.postgres.embedded.EmbeddedPostgres;
import de.softwareforge.testing.postgres.embedded.EmbeddedPostgresPreparer;
import jakarta.annotation.Nonnull;
import java.sql.SQLException;
import java.util.Set;
import java.util.UUID;
import javax.sql.DataSource;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EmbeddedPgExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedPgExtension.class);
    private final ExtensionContext.Namespace pgNamespace = ExtensionContext.Namespace.create((Object[])new Object[]{UUID.randomUUID()});
    private final DatabaseManager.Builder<DatabaseManager> databaseManagerBuilder;
    private volatile DatabaseManager databaseManager = null;

    private EmbeddedPgExtension(DatabaseManager.Builder<DatabaseManager> databaseManagerBuilder) {
        this.databaseManagerBuilder = databaseManagerBuilder;
    }

    @Nonnull
    static EmbeddedPgExtensionBuilder multiDatabase() {
        return new EmbeddedPgExtensionBuilder(true);
    }

    @Nonnull
    static EmbeddedPgExtensionBuilder singleDatabase() {
        return new EmbeddedPgExtensionBuilder(false);
    }

    public EmbeddedPgExtension() {
        this(new DatabaseManager.DatabaseManagerBuilder(true).withInstancePreparer(EmbeddedPostgres.Builder::withDefaults));
    }

    @Nonnull
    public DataSource createDataSource() throws SQLException {
        return this.createDatabaseInfo().asDataSource();
    }

    @VisibleForTesting
    EmbeddedPostgres getEmbeddedPostgres() {
        return this.databaseManager.getEmbeddedPostgres();
    }

    @Nonnull
    public DatabaseInfo createDatabaseInfo() throws SQLException {
        Preconditions.checkState((this.databaseManager != null ? 1 : 0) != 0, (Object)"no before method has been called!");
        DatabaseInfo databaseInfo = this.databaseManager.getDatabaseInfo();
        LOG.info("Connection to {}", (Object)databaseInfo.asJdbcUrl());
        return databaseInfo;
    }

    public void beforeAll(@Nonnull ExtensionContext extensionContext) throws Exception {
        Preconditions.checkNotNull((Object)extensionContext, (Object)"extensionContext is null");
        ExtensionContext.Store pgStore = extensionContext.getStore(this.pgNamespace);
        TestingContext testingContext = (TestingContext)pgStore.getOrComputeIfAbsent(TestingContext.TESTING_CONTEXT_KEY, k -> new TestingContext(extensionContext.getUniqueId(), this.databaseManagerBuilder.build()), TestingContext.class);
        this.databaseManager = testingContext.start(extensionContext.getUniqueId());
    }

    public void afterAll(@Nonnull ExtensionContext extensionContext) throws Exception {
        Preconditions.checkNotNull((Object)extensionContext, (Object)"extensionContext is null");
        ExtensionContext.Store pgStore = extensionContext.getStore(this.pgNamespace);
        TestingContext testingContext = (TestingContext)pgStore.get(TestingContext.TESTING_CONTEXT_KEY, TestingContext.class);
        if (testingContext != null) {
            this.databaseManager = testingContext.stop(extensionContext.getUniqueId());
        }
    }

    public void beforeEach(@Nonnull ExtensionContext extensionContext) throws Exception {
        Preconditions.checkNotNull((Object)extensionContext, (Object)"extensionContext is null");
        ExtensionContext.Store pgStore = extensionContext.getStore(this.pgNamespace);
        TestingContext testingContext = (TestingContext)pgStore.getOrComputeIfAbsent(TestingContext.TESTING_CONTEXT_KEY, k -> new TestingContext(extensionContext.getUniqueId(), this.databaseManagerBuilder.build()), TestingContext.class);
        this.databaseManager = testingContext.start(extensionContext.getUniqueId());
    }

    public void afterEach(@Nonnull ExtensionContext extensionContext) throws Exception {
        Preconditions.checkNotNull((Object)extensionContext, (Object)"extensionContext is null");
        ExtensionContext.Store pgStore = extensionContext.getStore(this.pgNamespace);
        TestingContext testingContext = (TestingContext)pgStore.get(TestingContext.TESTING_CONTEXT_KEY, TestingContext.class);
        if (testingContext != null) {
            this.databaseManager = testingContext.stop(extensionContext.getUniqueId());
        }
    }

    public boolean supportsParameter(@Nonnull ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> type = parameterContext.getParameter().getType();
        return type == EmbeddedPostgres.class || type == DatabaseInfo.class || type == DataSource.class;
    }

    public Object resolveParameter(@Nonnull ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> type = parameterContext.getParameter().getType();
        try {
            if (type == EmbeddedPostgres.class) {
                return this.getEmbeddedPostgres();
            }
            if (type == DatabaseInfo.class) {
                return this.createDatabaseInfo();
            }
            if (type == DataSource.class) {
                return this.createDataSource();
            }
        }
        catch (SQLException e) {
            throw new ParameterResolutionException("Could not create " + type.getTypeName() + " instance", (Throwable)e);
        }
        return null;
    }

    public static final class EmbeddedPgExtensionBuilder
    extends DatabaseManager.Builder<EmbeddedPgExtension> {
        private EmbeddedPgExtensionBuilder(boolean multiMode) {
            super(multiMode);
        }

        @Override
        @Nonnull
        public EmbeddedPgExtension build() {
            DatabaseManager.Builder<DatabaseManager> databaseManagerBuilder = new DatabaseManager.DatabaseManagerBuilder(this.multiMode).withDatabasePreparers((Set<EmbeddedPostgresPreparer<DataSource>>)this.databasePreparers.build()).withInstancePreparers((Set<EmbeddedPostgresPreparer<EmbeddedPostgres.Builder>>)this.instancePreparers.build());
            return new EmbeddedPgExtension(databaseManagerBuilder);
        }
    }

    private static final class TestingContext {
        private static final Object TESTING_CONTEXT_KEY = new Object();
        private final String id;
        private final DatabaseManager databaseManager;

        private TestingContext(String id, DatabaseManager databaseManager) {
            this.id = id;
            this.databaseManager = databaseManager;
        }

        private DatabaseManager start(String id) throws Exception {
            if (this.id.equals(id)) {
                this.databaseManager.start();
            }
            return this.databaseManager;
        }

        private DatabaseManager stop(String id) throws Exception {
            if (this.id.equals(id)) {
                this.databaseManager.close();
                return null;
            }
            return this.databaseManager;
        }
    }
}

