/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.embedded;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;

final class ProcessOutputLogger
implements Closeable {
    private final Logger logger;
    private final ListeningExecutorService executorService;

    ProcessOutputLogger(Logger errorLogger) {
        this.logger = errorLogger;
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("logger-thread-%d").build()));
    }

    @Override
    public void close() {
        this.executorService.shutdownNow();
    }

    StreamCapture captureStreamAsLog() {
        return new StreamCapture(arg_0 -> ((Logger)this.logger).debug(arg_0));
    }

    StreamCapture captureStreamAsConsumer(Consumer<String> consumer) {
        return new StreamCapture(consumer);
    }

    final class StreamCapture
    implements BiConsumer<String, InputStream> {
        private final Consumer<String> consumer;
        private volatile Future<?> completionFuture = null;

        private StreamCapture(Consumer<String> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void accept(String name, InputStream inputStream) {
            this.completionFuture = ProcessOutputLogger.this.executorService.submit((Runnable)new LogRunnable(name, inputStream, this.consumer));
        }

        public Future<?> getCompletion() {
            return this.completionFuture;
        }
    }

    private final class LogRunnable
    implements Runnable {
        private final InputStream inputStream;
        private final String name;
        private final Consumer<String> consumer;

        private LogRunnable(String name, InputStream inputStream, Consumer<String> consumer) {
            this.name = name;
            this.inputStream = inputStream;
            this.consumer = consumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String oldName = Thread.currentThread().getName();
            Thread.currentThread().setName(this.name);
            try (InputStreamReader isr = new InputStreamReader(this.inputStream, StandardCharsets.UTF_8);
                 BufferedReader reader = new BufferedReader(isr);){
                try {
                    reader.lines().forEach(this.consumer);
                }
                catch (UncheckedIOException e) {
                    ProcessOutputLogger.this.logger.error("while reading output:", (Throwable)e);
                }
            }
            catch (IOException e) {
                ProcessOutputLogger.this.logger.error("while opening log stream", (Throwable)e);
            }
            finally {
                Thread.currentThread().setName(oldName + " (" + this.name + ")");
            }
        }
    }
}

