/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.embedded;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;

public interface NativeBinaryLocator {
    public static final String INSTALL_DIRECTORY_PREFIX = "bin-";

    @Nullable
    public InputStream getInputStream() throws IOException;

    @Nonnull
    default public String getIdentifier() throws IOException {
        try (InputStream installationArchive = this.getInputStream();){
            String string;
            Preconditions.checkState((installationArchive != null ? 1 : 0) != 0, (String)"Locator '%s' did not find a suitable archive to unpack!", (Object)this.toString());
            try (HashingInputStream hashStream = new HashingInputStream(Hashing.murmur3_128(), installationArchive);){
                ByteStreams.exhaust((InputStream)hashStream);
                string = INSTALL_DIRECTORY_PREFIX + BaseEncoding.base16().encode(hashStream.hash().asBytes());
            }
            return string;
        }
    }
}

