/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.embedded;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;

final class EmbeddedUtil {
    static final String OS_NAME = EmbeddedUtil.getSystemProperty("os.name");
    static final String OS_ARCH = EmbeddedUtil.getSystemProperty("os.arch");
    static final boolean IS_OS_WINDOWS = EmbeddedUtil.getOsMatchesName("Windows");
    static final boolean IS_OS_MAC;
    static final boolean IS_OS_LINUX;
    static final boolean IS_ALPINE_LINUX;
    static final boolean IS_ARCH_X86_64;
    static final boolean IS_ARCH_AARCH64;
    static final boolean IS_ARCH_AARCH32;
    private static final String ALPHANUM;
    private static final String LOWERCASE;

    private EmbeddedUtil() {
        throw new AssertionError((Object)"EmbeddedUtil can not be instantiated");
    }

    static File getWorkingDirectory() {
        File parent = new File(System.getProperty("java.io.tmpdir"));
        File workDir = new File(parent, "embedded-pg-" + Objects.requireNonNullElse(System.getProperty("user.name"), "unknown"));
        EmbeddedUtil.ensureDirectory(workDir);
        return workDir;
    }

    static void ensureDirectory(@Nonnull File workDir) {
        if (!workDir.exists()) {
            Preconditions.checkState((boolean)workDir.mkdirs(), (String)" Could not create directory '%s'", (Object)workDir);
        }
        Preconditions.checkState((boolean)workDir.exists(), (String)"'%s' does not exist!", (Object)workDir);
        Preconditions.checkState((boolean)workDir.isDirectory(), (String)"'%s' exists but is not a directory!", (Object)workDir);
        if (!workDir.canWrite()) {
            Preconditions.checkState((boolean)workDir.setWritable(true, false), (String)"Could not make directory '%s' writeable!", (Object)workDir);
        }
        Preconditions.checkState((boolean)workDir.canWrite(), (String)"'%s' is a directory but can not be written!", (Object)workDir);
    }

    static String getFileBaseName(String fileName) {
        if (fileName == null) {
            return null;
        }
        EmbeddedUtil.failIfNullBytePresent(fileName);
        int index = EmbeddedUtil.indexOfLastSeparator(fileName);
        return fileName.substring(index + 1);
    }

    private static void failIfNullBytePresent(String path) {
        int len = path.length();
        for (int i = 0; i < len; ++i) {
            Preconditions.checkArgument((path.charAt(i) != '\u0000' ? 1 : 0) != 0, (Object)"Null byte present in file/path name.");
        }
    }

    private static int indexOfLastSeparator(String fileName) {
        if (fileName == null) {
            return -1;
        }
        int lastUnixPos = fileName.lastIndexOf(47);
        int lastWindowsPos = fileName.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    static void rmdirs(File dir) throws IOException {
        if (dir.exists() && dir.isDirectory()) {
            try (Stream<Path> walk = Files.walk(dir.toPath(), new FileVisitOption[0]);){
                walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
        }
    }

    static String formatDuration(Duration duration) {
        long millis = duration.toMillis();
        ImmutableList.Builder builder = ImmutableList.builder();
        if (millis == 0L) {
            builder.add((Object)"0 ms");
        } else {
            long seconds = millis / 1000L;
            long hours = seconds / 3600L;
            long minutes = seconds % 3600L / 60L;
            long secs = seconds % 60L;
            long ms = millis % 1000L;
            if (hours != 0L) {
                builder.add((Object)(hours + " hours"));
            }
            if (minutes != 0L) {
                builder.add((Object)(minutes + " minutes"));
            }
            if (secs != 0L) {
                builder.add((Object)(secs + " seconds"));
            }
            if (ms != 0L) {
                builder.add((Object)(ms + " ms"));
            }
        }
        return Joiner.on((char)' ').join((Iterable)builder.build());
    }

    static int allocatePort() throws IOException {
        int n;
        ServerSocket socket = new ServerSocket(0);
        try {
            while (!socket.isBound()) {
                Thread.sleep(50L);
            }
            n = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Thread interrupted!", e);
            }
        }
        socket.close();
        return n;
    }

    static String randomAlphaNumeric(int length) {
        return EmbeddedUtil.randomString(ALPHANUM, length);
    }

    static String randomLowercase(int length) {
        return EmbeddedUtil.randomString(LOWERCASE, length);
    }

    private static String sequence(char start, int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append((char)(start + i));
        }
        return sb.toString();
    }

    private static String randomString(String alphabet, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int random = ThreadLocalRandom.current().nextInt(alphabet.length());
            sb.append(alphabet.charAt(random));
        }
        return sb.toString();
    }

    private static String getSystemProperty(String propertyName) {
        try {
            return Strings.nullToEmpty((String)System.getProperty(propertyName, ""));
        }
        catch (SecurityException e) {
            return "<unknown>";
        }
    }

    private static boolean getOsMatchesName(String osNamePrefix) {
        return OS_NAME.toLowerCase(Locale.ROOT).startsWith(osNamePrefix.toLowerCase(Locale.ROOT));
    }

    static {
        IS_OS_LINUX = EmbeddedUtil.getOsMatchesName("Linux");
        IS_OS_MAC = EmbeddedUtil.getOsMatchesName("Mac");
        IS_ARCH_X86_64 = OS_ARCH.equals("x86_64") || OS_ARCH.equals("amd64");
        IS_ARCH_AARCH64 = OS_ARCH.equals("aarch64");
        IS_ARCH_AARCH32 = OS_ARCH.equals("aarch32") || OS_ARCH.equals("arm");
        IS_ALPINE_LINUX = new File("/etc/alpine-release").exists();
        String numbers = EmbeddedUtil.sequence('0', 10);
        LOWERCASE = EmbeddedUtil.sequence('a', 26);
        String uppercase = EmbeddedUtil.sequence('A', 26);
        ALPHANUM = numbers + LOWERCASE + uppercase;
    }
}

