/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.embedded;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import de.softwareforge.testing.postgres.embedded.AutoValue_DatabaseInfo;
import de.softwareforge.testing.postgres.embedded.EmbeddedPostgres;
import jakarta.annotation.Nonnull;
import java.sql.SQLException;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;

@AutoValue
public abstract class DatabaseInfo {
    private static final String JDBC_FORMAT = "jdbc:postgresql://localhost:%d/%s?user=%s";
    static final String PG_DEFAULT_USER = "postgres";
    static final String PG_DEFAULT_DB = "postgres";

    DatabaseInfo() {
    }

    @Nonnull
    public abstract String dbName();

    public abstract int port();

    @Nonnull
    public abstract String user();

    @Nonnull
    public abstract ImmutableMap<String, String> connectionProperties();

    @Nonnull
    abstract Optional<SQLException> exception();

    @Nonnull
    static Builder builder() {
        return new AutoValue_DatabaseInfo.Builder().dbName("postgres").user("postgres");
    }

    @Nonnull
    static DatabaseInfo forException(SQLException e) {
        return DatabaseInfo.builder().exception(e).port(-1).build();
    }

    @Nonnull
    public String asJdbcUrl() {
        Preconditions.checkState((boolean)this.exception().isEmpty(), (String)"DatabaseInfo contains SQLException: %s", this.exception());
        String additionalParameters = this.connectionProperties().entrySet().stream().map(e -> String.format("&%s=%s", e.getKey(), e.getValue())).collect(Collectors.joining());
        return String.format(JDBC_FORMAT, this.port(), this.dbName(), this.user()) + additionalParameters;
    }

    @Nonnull
    public DataSource asDataSource() throws SQLException {
        if (this.exception().isPresent()) {
            throw this.exception().get();
        }
        return EmbeddedPostgres.createDataSource(this.user(), this.dbName(), this.port(), this.connectionProperties());
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder dbName(String var1);

        abstract Builder port(int var1);

        abstract Builder user(String var1);

        abstract Builder exception(SQLException var1);

        abstract ImmutableMap.Builder<String, String> connectionPropertiesBuilder();

        final Builder addConnectionProperty(String key, String value) {
            this.connectionPropertiesBuilder().put((Object)key, (Object)value);
            return this;
        }

        abstract Builder connectionProperties(ImmutableMap<String, String> var1);

        abstract DatabaseInfo build();
    }
}

