/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.embedded;

import com.google.common.collect.ImmutableMap;
import de.softwareforge.testing.postgres.embedded.DatabaseInfo;
import jakarta.annotation.Nonnull;
import java.sql.SQLException;
import java.util.Optional;

final class AutoValue_DatabaseInfo
extends DatabaseInfo {
    private final String dbName;
    private final int port;
    private final String user;
    private final ImmutableMap<String, String> connectionProperties;
    private final Optional<SQLException> exception;

    private AutoValue_DatabaseInfo(String dbName, int port, String user, ImmutableMap<String, String> connectionProperties, Optional<SQLException> exception) {
        this.dbName = dbName;
        this.port = port;
        this.user = user;
        this.connectionProperties = connectionProperties;
        this.exception = exception;
    }

    @Override
    @Nonnull
    public String dbName() {
        return this.dbName;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    @Nonnull
    public String user() {
        return this.user;
    }

    @Override
    @Nonnull
    public ImmutableMap<String, String> connectionProperties() {
        return this.connectionProperties;
    }

    @Override
    @Nonnull
    Optional<SQLException> exception() {
        return this.exception;
    }

    public String toString() {
        return "DatabaseInfo{dbName=" + this.dbName + ", port=" + this.port + ", user=" + this.user + ", connectionProperties=" + this.connectionProperties + ", exception=" + this.exception + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DatabaseInfo) {
            DatabaseInfo that = (DatabaseInfo)o;
            return this.dbName.equals(that.dbName()) && this.port == that.port() && this.user.equals(that.user()) && this.connectionProperties.equals(that.connectionProperties()) && this.exception.equals(that.exception());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.dbName.hashCode();
        h$ *= 1000003;
        h$ ^= this.port;
        h$ *= 1000003;
        h$ ^= this.user.hashCode();
        h$ *= 1000003;
        h$ ^= this.connectionProperties.hashCode();
        h$ *= 1000003;
        return h$ ^= this.exception.hashCode();
    }

    static final class Builder
    extends DatabaseInfo.Builder {
        private String dbName;
        private int port;
        private String user;
        private ImmutableMap.Builder<String, String> connectionPropertiesBuilder$;
        private ImmutableMap<String, String> connectionProperties;
        private Optional<SQLException> exception = Optional.empty();
        private byte set$0;

        Builder() {
        }

        @Override
        DatabaseInfo.Builder dbName(String dbName) {
            if (dbName == null) {
                throw new NullPointerException("Null dbName");
            }
            this.dbName = dbName;
            return this;
        }

        @Override
        DatabaseInfo.Builder port(int port) {
            this.port = port;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        DatabaseInfo.Builder user(String user) {
            if (user == null) {
                throw new NullPointerException("Null user");
            }
            this.user = user;
            return this;
        }

        @Override
        DatabaseInfo.Builder connectionProperties(ImmutableMap<String, String> connectionProperties) {
            if (connectionProperties == null) {
                throw new NullPointerException("Null connectionProperties");
            }
            if (this.connectionPropertiesBuilder$ != null) {
                throw new IllegalStateException("Cannot set connectionProperties after calling connectionPropertiesBuilder()");
            }
            this.connectionProperties = connectionProperties;
            return this;
        }

        @Override
        ImmutableMap.Builder<String, String> connectionPropertiesBuilder() {
            if (this.connectionPropertiesBuilder$ == null) {
                if (this.connectionProperties == null) {
                    this.connectionPropertiesBuilder$ = ImmutableMap.builder();
                } else {
                    this.connectionPropertiesBuilder$ = ImmutableMap.builder();
                    this.connectionPropertiesBuilder$.putAll(this.connectionProperties);
                    this.connectionProperties = null;
                }
            }
            return this.connectionPropertiesBuilder$;
        }

        @Override
        DatabaseInfo.Builder exception(SQLException exception) {
            this.exception = Optional.of(exception);
            return this;
        }

        @Override
        DatabaseInfo build() {
            if (this.connectionPropertiesBuilder$ != null) {
                this.connectionProperties = this.connectionPropertiesBuilder$.buildOrThrow();
            } else if (this.connectionProperties == null) {
                this.connectionProperties = ImmutableMap.of();
            }
            if (this.set$0 != 1 || this.dbName == null || this.user == null) {
                StringBuilder missing = new StringBuilder();
                if (this.dbName == null) {
                    missing.append(" dbName");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" port");
                }
                if (this.user == null) {
                    missing.append(" user");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_DatabaseInfo(this.dbName, this.port, this.user, this.connectionProperties, this.exception);
        }
    }
}

