/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.maven.org.eclipse.sisu.space;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.matcher.Matcher;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.TypeListener;
import de.softwareforge.testing.maven.javax.inject.$Named;
import de.softwareforge.testing.maven.javax.inject.$Provider;
import de.softwareforge.testing.maven.javax.inject.$Singleton;
import de.softwareforge.testing.maven.org.eclipse.sisu.$EagerSingleton;
import de.softwareforge.testing.maven.org.eclipse.sisu.$Mediator;
import de.softwareforge.testing.maven.org.eclipse.sisu.$Typed;
import de.softwareforge.testing.maven.org.eclipse.sisu.inject.$Legacy;
import de.softwareforge.testing.maven.org.eclipse.sisu.inject.$TypeArguments;
import de.softwareforge.testing.maven.org.eclipse.sisu.space.$MediationListener;
import de.softwareforge.testing.maven.org.eclipse.sisu.space.$QualifiedTypeListener;
import de.softwareforge.testing.maven.org.eclipse.sisu.space.$WildcardKey;
import de.softwareforge.testing.maven.org.sonatype.inject.;
import java.lang.annotation.Annotation;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.enterprise.inject.Typed;

public final class $QualifiedTypeBinder
implements $QualifiedTypeListener {
    private static final TypeLiteral<Object> OBJECT_TYPE_LITERAL;
    private static final boolean HAS_JSR299_TYPED;
    private final Binder rootBinder;
    private $MediationListener mediationListener;
    private Object currentSource;
    private Binder binder;

    public $QualifiedTypeBinder(Binder binder) {
        this.rootBinder = binder;
        this.binder = binder;
    }

    public void hear(Class qualifiedType, Object source) {
        if (this.currentSource != source) {
            if (null != source) {
                this.binder = this.rootBinder.withSource(source);
                this.currentSource = source;
            } else {
                this.binder = this.rootBinder;
                this.currentSource = null;
            }
        }
        if (!$TypeArguments.isConcrete(qualifiedType)) {
            return;
        }
        if (Module.class.isAssignableFrom(qualifiedType)) {
            this.installModule(qualifiedType);
        } else if ($Mediator.class.isAssignableFrom(qualifiedType)) {
            this.registerMediator(qualifiedType);
        } else if (de.softwareforge.testing.maven.org.sonatype.inject.$Mediator.class.isAssignableFrom(qualifiedType)) {
            this.registerLegacyMediator(qualifiedType);
        } else if ($Provider.class.isAssignableFrom(qualifiedType)) {
            this.bindProviderType(qualifiedType);
        } else {
            this.bindQualifiedType(qualifiedType);
        }
    }

    private void installModule(Class<Module> moduleType) {
        Module module = this.newInstance(moduleType);
        if (null != module) {
            this.binder.install(module);
        }
    }

    private void registerMediator(Class<$Mediator> mediatorType) {
        TypeLiteral<?>[] args = $QualifiedTypeBinder.resolveTypeArguments(mediatorType, $Mediator.class);
        if (args.length != 3) {
            this.binder.addError(mediatorType + " has wrong number of type arguments", new Object[0]);
        } else {
            $Mediator mediator = this.newInstance(mediatorType);
            if (null != mediator) {
                this.mediate($QualifiedTypeBinder.watchedKey(args[1], args[0].getRawType()), mediator, args[2].getRawType());
            }
        }
    }

    private void registerLegacyMediator(Class<de.softwareforge.testing.maven.org.sonatype.inject.$Mediator> mediatorType) {
        TypeLiteral<?>[] args = $QualifiedTypeBinder.resolveTypeArguments(mediatorType, de.softwareforge.testing.maven.org.sonatype.inject.$Mediator.class);
        if (args.length != 3) {
            this.binder.addError(mediatorType + " has wrong number of type arguments", new Object[0]);
        } else {
            $Mediator mediator = $Legacy.adapt(this.newInstance(mediatorType));
            if (null != mediator) {
                this.mediate($QualifiedTypeBinder.watchedKey(args[1], args[0].getRawType()), mediator, args[2].getRawType());
            }
        }
    }

    private void mediate(Key watchedKey, $Mediator mediator, Class watcherType) {
        if (null == this.mediationListener) {
            this.mediationListener = new $MediationListener(this.binder);
            this.binder.bindListener((Matcher)this.mediationListener, (TypeListener)this.mediationListener);
        }
        this.mediationListener.mediate(watchedKey, mediator, watcherType);
    }

    private void bindProviderType(Class<?> providerType) {
        TypeLiteral<?>[] args = $QualifiedTypeBinder.resolveTypeArguments(providerType, $Provider.class);
        if (args.length != 1) {
            this.binder.addError(providerType + " has wrong number of type arguments", new Object[0]);
        } else {
            this.binder.bind(providerType).in(Scopes.SINGLETON);
            Named bindingName = $QualifiedTypeBinder.getBindingName(providerType);
            Class<?>[] types = $QualifiedTypeBinder.getBindingTypes(providerType);
            Key<?> key = $QualifiedTypeBinder.getBindingKey(args[0], (Annotation)bindingName);
            ScopedBindingBuilder sbb = this.binder.bind(key).toProvider(providerType);
            if ($QualifiedTypeBinder.isEagerSingleton(providerType)) {
                sbb.asEagerSingleton();
            } else if ($QualifiedTypeBinder.isSingleton(providerType)) {
                sbb.in(Scopes.SINGLETON);
            }
            if (null != types) {
                for (Class<?> bindingType : types) {
                    this.binder.bind(key.ofType(bindingType)).to(key);
                }
            }
        }
    }

    private void bindQualifiedType(Class<?> qualifiedType) {
        AnnotatedBindingBuilder sbb = this.binder.bind(qualifiedType);
        if ($QualifiedTypeBinder.isEagerSingleton(qualifiedType)) {
            sbb.asEagerSingleton();
        }
        Named bindingName = $QualifiedTypeBinder.getBindingName(qualifiedType);
        Class<?>[] types = $QualifiedTypeBinder.getBindingTypes(qualifiedType);
        if (null != types) {
            Key<Object> key = $QualifiedTypeBinder.getBindingKey(OBJECT_TYPE_LITERAL, (Annotation)bindingName);
            for (Class<?> bindingType : types) {
                this.binder.bind(key.ofType(bindingType)).to(qualifiedType);
            }
        } else {
            this.binder.bind($WildcardKey.get(qualifiedType, (Annotation)bindingName)).to(qualifiedType);
        }
    }

    private void bindQualifiedInstance(Object qualifiedInstance) {
        Class<?> qualifiedType = qualifiedInstance.getClass();
        Named bindingName = $QualifiedTypeBinder.getBindingName(qualifiedType);
        Class<?>[] types = $QualifiedTypeBinder.getBindingTypes(qualifiedType);
        if (null != types) {
            Key<Object> key = $QualifiedTypeBinder.getBindingKey(OBJECT_TYPE_LITERAL, (Annotation)bindingName);
            for (Class<?> bindingType : types) {
                this.binder.bind(key.ofType(bindingType)).toInstance(qualifiedInstance);
            }
        } else {
            this.binder.bind($WildcardKey.get(qualifiedType, (Annotation)bindingName)).toInstance(qualifiedInstance);
        }
    }

    private <T> T newInstance(Class<T> type) {
        try {
            final Constructor<T> ctor = type.getDeclaredConstructor(new Class[0]);
            if (!ctor.isAccessible()) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        ctor.setAccessible(true);
                        return null;
                    }
                });
            }
            T instance = ctor.newInstance(new Object[0]);
            this.bindQualifiedInstance(instance);
            return instance;
        }
        catch (Exception e) {
            Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
            this.binder.addError("Error creating instance of: " + type + " reason: " + cause, new Object[0]);
            return null;
        }
        catch (LinkageError e) {
            this.binder.addError("Error creating instance of: " + type + " reason: " + e, new Object[0]);
            return null;
        }
    }

    private static TypeLiteral<?>[] resolveTypeArguments(Class<?> type, Class<?> superType) {
        return $TypeArguments.get(TypeLiteral.get(type).getSupertype(superType));
    }

    private static <T> Key<T> getBindingKey(TypeLiteral<T> bindingType, Annotation qualifier) {
        return null != qualifier ? Key.get(bindingType, (Annotation)qualifier) : Key.get(bindingType);
    }

    private static Named getBindingName(Class<?> qualifiedType) {
        $Named jsr330 = qualifiedType.getAnnotation($Named.class);
        if (null != jsr330) {
            try {
                String name = jsr330.value();
                if (name.length() > 0) {
                    return "default".equals(name) ? null : Names.named((String)name);
                }
            }
            catch (IncompleteAnnotationException name) {}
        } else {
            String name;
            Named guice = qualifiedType.getAnnotation(Named.class);
            if (null != guice && (name = guice.value()).length() > 0) {
                return "default".equals(name) ? null : guice;
            }
        }
        if (qualifiedType.getSimpleName().startsWith("Default")) {
            return null;
        }
        return Names.named((String)qualifiedType.getName());
    }

    private static Class<?>[] getBindingTypes(Class<?> clazz) {
        for (Class<?> c = clazz; null != c && c != Object.class; c = c.getSuperclass()) {
            Object typed;
            if (HAS_JSR299_TYPED && null != (typed = c.getAnnotation(Typed.class))) {
                return typed.value().length > 0 ? typed.value() : c.getInterfaces();
            }
            typed = c.getAnnotation($Typed.class);
            if (null == typed) continue;
            return typed.value().length > 0 ? typed.value() : c.getInterfaces();
        }
        return null;
    }

    private static boolean isSingleton(Class<?> type) {
        return type.isAnnotationPresent($Singleton.class) || type.isAnnotationPresent(Singleton.class);
    }

    private static boolean isEagerSingleton(Class<?> type) {
        return type.isAnnotationPresent($EagerSingleton.class) || type.isAnnotationPresent(.EagerSingleton.class);
    }

    private static <T> Key<T> watchedKey(TypeLiteral<T> type, Class qualifierType) {
        return qualifierType.isAnnotation() ? Key.get(type, (Class)qualifierType) : Key.get(type);
    }

    static {
        boolean hasJsr299Typed;
        try {
            hasJsr299Typed = Typed.class.isAnnotation();
        }
        catch (LinkageError e) {
            hasJsr299Typed = false;
        }
        HAS_JSR299_TYPED = hasJsr299Typed;
        OBJECT_TYPE_LITERAL = TypeLiteral.get(Object.class);
    }
}

