/*
 * Decompiled with CFR 0.152.
 */
package com.dumbster.smtp.mailstores;

import com.dumbster.smtp.MailMessage;
import com.dumbster.smtp.MailStore;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingMailStore
implements MailStore {
    private final Logger LOG = LoggerFactory.getLogger(RollingMailStore.class);
    private Deque<MailMessage> receivedMail;

    public RollingMailStore() {
        this(100);
    }

    public RollingMailStore(int size) {
        this.receivedMail = new LinkedBlockingDeque<MailMessage>(size);
    }

    @Override
    public int getEmailCount() {
        return this.receivedMail.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessage(MailMessage message) {
        Objects.requireNonNull(message, "message is null");
        this.LOG.debug("Received message: " + message);
        Deque<MailMessage> deque = this.receivedMail;
        synchronized (deque) {
            if (!this.receivedMail.offer(message)) {
                this.receivedMail.remove();
                this.receivedMail.add(message);
            }
        }
    }

    @Override
    public MailMessage[] getMessages() {
        return this.receivedMail.toArray(new MailMessage[this.receivedMail.size()]);
    }

    @Override
    public MailMessage getMessage(int index) {
        return this.getMessages()[index];
    }

    @Override
    public void clearMessages() {
        this.receivedMail.clear();
    }
}

