/*
 * Decompiled with CFR 0.152.
 */
package com.dumbster.smtp;

import com.dumbster.smtp.MailStore;
import com.dumbster.smtp.mailstores.RollingMailStore;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Objects;

public class ServerOptions {
    public static final int SMTP_PORT = 25;
    private int port = 25;
    private boolean threaded = true;
    private MailStore mailStore = new RollingMailStore();
    private int waitInResponse = 0;

    public ServerOptions() {
    }

    public ServerOptions(String[] args) {
        if (args.length == 0) {
            return;
        }
        for (String argument : args) {
            if (argument.startsWith("--mailStore")) {
                String[] values = argument.split("=");
                if (values.length != 2) {
                    throw new IllegalArgumentException("--mailStore must have an argument");
                }
                String className = "com.dumbster.smtp.mailstores." + values[1];
                try {
                    this.withMailStore((MailStore)Class.forName(className).newInstance());
                    continue;
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalArgumentException("Could not instantiate mail store class: " + className, e);
                }
            }
            if (argument.startsWith("--threaded")) {
                if (argument.equalsIgnoreCase("--threaded=false")) {
                    this.notThreaded();
                    continue;
                }
                this.threaded();
                continue;
            }
            try {
                this.withSmtpPort(Integer.parseInt(argument));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("'" + argument + "' is not a valid number");
            }
        }
    }

    public ServerOptions threaded() {
        this.threaded = true;
        return this;
    }

    public ServerOptions notThreaded() {
        this.threaded = false;
        return this;
    }

    public ServerOptions withMailStore(MailStore mailStore) {
        Objects.requireNonNull(mailStore, "mailStore is null");
        this.mailStore = mailStore;
        return this;
    }

    public ServerOptions withDefaultSmtpPort() {
        this.port = 25;
        return this;
    }

    public ServerOptions withRandomSmtpPort() {
        this.port = ServerOptions.randomPort();
        return this;
    }

    public ServerOptions withSmtpPort(int port) {
        if (port <= 0 || port > 65534) {
            throw new IllegalArgumentException(String.format("Port %d must be > 0 and < 65535", port));
        }
        this.port = port;
        return this;
    }

    public ServerOptions withWaitInResponseInMs(int waitInResponse) {
        if (waitInResponse < 0) {
            throw new IllegalArgumentException("waitInResponse must be > 0");
        }
        this.waitInResponse = waitInResponse;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isThreaded() {
        return this.threaded;
    }

    public MailStore getMailStore() {
        return this.mailStore;
    }

    public int getWaitInResponse() {
        return this.waitInResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int randomPort() {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not allocate a free port", e);
        }
    }
}

