/*
 * Decompiled with CFR 0.152.
 */
package com.dumbster.smtp;

import com.dumbster.smtp.MailMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MailMessageImpl
implements MailMessage {
    private Map<String, List<String>> headers = new HashMap<String, List<String>>(10);
    private StringBuffer body = new StringBuffer();

    @Override
    public Iterator<String> getHeaderNames() {
        Set<String> nameSet = this.headers.keySet();
        return nameSet.iterator();
    }

    @Override
    public String[] getHeaderValues(String name) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            return new String[0];
        }
        return values.toArray(new String[values.size()]);
    }

    @Override
    public String getFirstHeaderValue(String name) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            return null;
        }
        Iterator<String> iterator = values.iterator();
        return iterator.next();
    }

    @Override
    public String getBody() {
        return this.body.toString();
    }

    @Override
    public void addHeader(String name, String value) {
        List<String> valueList = this.headers.get(name);
        if (valueList == null) {
            valueList = new ArrayList<String>(1);
        }
        valueList.add(value);
        this.headers.put(name, valueList);
    }

    @Override
    public void appendHeader(String name, String value) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            this.addHeader(name, value);
        } else {
            String oldValue = values.get(values.size() - 1);
            values.remove(oldValue);
            values.add(oldValue + value);
            this.headers.put(name, values);
        }
    }

    @Override
    public void appendBody(String line) {
        if (this.shouldPrependNewline(line)) {
            this.body.append('\n');
        }
        this.body.append(line);
    }

    private boolean shouldPrependNewline(String line) {
        return this.body.length() > 0 && line.length() > 0 && !"\n".equals(line);
    }

    public String toString() {
        StringBuffer msg = new StringBuffer();
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            String name = entry.getKey();
            for (String value : entry.getValue()) {
                msg.append(name);
                msg.append(": ");
                msg.append(value);
                msg.append('\n');
            }
        }
        msg.append('\n');
        msg.append(this.body);
        msg.append('\n');
        return msg.toString();
    }
}

