/*
 * Decompiled with CFR 0.152.
 */
package yahoofinance.quotes.csv;

import java.util.ArrayList;
import java.util.List;
import yahoofinance.Utils;
import yahoofinance.quotes.csv.QuotesProperty;
import yahoofinance.quotes.csv.QuotesRequest;
import yahoofinance.quotes.fx.FxQuote;

public class FxQuotesRequest
extends QuotesRequest<FxQuote> {
    public static final List<QuotesProperty> DEFAULT_PROPERTIES = new ArrayList<QuotesProperty>();

    public FxQuotesRequest(String query) {
        super(query, DEFAULT_PROPERTIES);
    }

    @Override
    protected FxQuote parseCSVLine(String line) {
        String[] split = Utils.stripOverhead(line).split(",");
        if (split.length >= 2) {
            return new FxQuote(split[0], Utils.getBigDecimal(split[1]));
        }
        return null;
    }

    static {
        DEFAULT_PROPERTIES.add(QuotesProperty.Symbol);
        DEFAULT_PROPERTIES.add(QuotesProperty.LastTradePriceOnly);
    }
}

