/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.lib.protocol.matcher;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.Vocabulary;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

class MessageMatcherErrorStrategy
extends DefaultErrorStrategy {
    static final ANTLRErrorStrategy INSTANCE = new MessageMatcherErrorStrategy();
    private static final String EOF_DISPLAY_NAME = "end of matcher";

    protected void reportInputMismatch(Parser recognizer, InputMismatchException ex) {
        IntervalSet expectedTokens = ex.getExpectedTokens();
        Token offendingToken = ex.getOffendingToken();
        if (this.isEOFToken(offendingToken)) {
            if (expectedTokens.size() <= 4) {
                recognizer.notifyErrorListeners(offendingToken, "incomplete matcher; expecting " + this.tokenList(expectedTokens, recognizer.getVocabulary()) + " at end", (RecognitionException)ex);
            } else {
                recognizer.notifyErrorListeners(offendingToken, "incomplete matcher", (RecognitionException)ex);
            }
        } else {
            String offendingTokenText = this.getTokenErrorDisplay(offendingToken);
            if (expectedTokens.size() <= 4) {
                recognizer.notifyErrorListeners(offendingToken, "mismatched input " + offendingTokenText + "; expecting " + this.tokenList(expectedTokens, recognizer.getVocabulary()), (RecognitionException)ex);
            } else {
                recognizer.notifyErrorListeners(offendingToken, "mismatched input " + offendingTokenText, (RecognitionException)ex);
            }
        }
    }

    @Contract(pure=true)
    protected String getTokenErrorDisplay(Token t) {
        return this.isEOFToken(t) ? EOF_DISPLAY_NAME : super.getTokenErrorDisplay(t);
    }

    @Contract(pure=true)
    private boolean isEOFToken(Token t) {
        return t != null && t.getType() == -1;
    }

    @Contract(pure=true)
    @NotNull
    private String tokenList(@NotNull IntervalSet tokens, @NotNull Vocabulary vocabulary) {
        StringBuilder list = new StringBuilder();
        Iterator<String> tokenNameIterator = this.getTokenDisplayNames(tokens, vocabulary).iterator();
        while (tokenNameIterator.hasNext()) {
            String tokenName = tokenNameIterator.next();
            if (list.length() > 0) {
                list.append(tokenNameIterator.hasNext() ? ", " : " or ");
            }
            list.append(tokenName);
        }
        return list.toString();
    }

    @Contract(pure=true)
    @NotNull
    private Set<String> getTokenDisplayNames(@NotNull IntervalSet tokens, @NotNull Vocabulary vocabulary) {
        return tokens.toSet().stream().map(arg_0 -> ((Vocabulary)vocabulary).getDisplayName(arg_0)).filter(s -> s != null && !s.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    MessageMatcherErrorStrategy() {
    }
}

