/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.lib.protocol.matcher.antlr;

import de.sayayi.lib.protocol.exception.MessageMatcherParserException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.IterativeParseTreeWalker;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAntlr4Compiler {
    @NotNull
    protected <L extends Lexer, P extends Parser, C extends ParserRuleContext> C compile(@NotNull L lexer, @NotNull Function<L, P> parserSupplier, @NotNull Function<P, C> executeRule) {
        final String compilerInput = ((CompilerInputSupplier)lexer).getCompilerInput();
        BaseErrorListener errorListener = new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException ex) {
                AbstractAntlr4Compiler.this.syntaxError(compilerInput, (Token)offendingSymbol, msg, ex);
            }
        };
        lexer.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        Parser parser = (Parser)parserSupplier.apply(lexer);
        parser.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        return (C)((ParserRuleContext)executeRule.apply(parser));
    }

    protected <L extends Lexer, P extends Parser, C extends ParserRuleContext, R> R compile(@NotNull L lexer, @NotNull Function<L, P> parserSupplier, @NotNull Function<P, C> executeRule, @NotNull ParseTreeListener listener, @NotNull Function<C, R> resultExtractor) {
        C parserRuleContext = this.compile(lexer, parserSupplier, executeRule);
        this.walk(listener, (ParseTree)parserRuleContext);
        return resultExtractor.apply(parserRuleContext);
    }

    @Contract(mutates="param2")
    private void walk(@NotNull ParseTreeListener listener, @NotNull ParseTree parseTree) {
        if (listener instanceof WalkerSupplier) {
            switch (((WalkerSupplier)listener).getWalker()) {
                case WALK_EXIT_RULES_ONLY: {
                    this.walkExitsOnly(listener, parseTree);
                    return;
                }
                case WALK_ENTRY_EXIT_RULES_ONLY: {
                    this.walkEntryExitsOnly(listener, parseTree);
                    return;
                }
                case WALK_FULL_HEAP: {
                    new IterativeParseTreeWalker().walk(listener, parseTree);
                    return;
                }
            }
        }
        ParseTreeWalker.DEFAULT.walk(listener, parseTree);
    }

    @Contract(mutates="param2")
    private void walkEntryExitsOnly(@NotNull ParseTreeListener listener, @NotNull ParseTree parseTree) {
        if (parseTree instanceof ParserRuleContext) {
            ((ParserRuleContext)parseTree).enterRule(listener);
            List children = ((ParserRuleContext)parseTree).children;
            if (children != null) {
                for (ParseTree parseTreeChild : children) {
                    this.walkEntryExitsOnly(listener, parseTreeChild);
                }
            }
            ((ParserRuleContext)parseTree).exitRule(listener);
        }
    }

    @Contract(mutates="param2")
    private void walkExitsOnly(@NotNull ParseTreeListener listener, @NotNull ParseTree parseTree) {
        if (parseTree instanceof ParserRuleContext) {
            List children = ((ParserRuleContext)parseTree).children;
            if (children != null) {
                for (ParseTree parseTreeChild : children) {
                    this.walkExitsOnly(listener, parseTreeChild);
                }
            }
            ((ParserRuleContext)parseTree).exitRule(listener);
        }
    }

    @Contract(value="_, _, _ -> fail")
    protected void syntaxError(@NotNull String compilerInput, @NotNull ParserRuleContext ctx, @NotNull String errorMsg) {
        this.syntaxError(compilerInput, ctx.getStart(), errorMsg, null);
    }

    @Contract(value="_, _, _, _ -> fail")
    protected void syntaxError(@NotNull String compilerInput, @NotNull Token token, @NotNull String errorMsg, RecognitionException ex) {
        String[] lines = compilerInput.split("\r?\n");
        if (lines.length == 1) {
            this.syntaxErrorSingleLine(compilerInput, token, errorMsg, ex);
        }
        throw this.createException(errorMsg, compilerInput, token.getStartIndex(), token.getStopIndex(), "", ex);
    }

    @Contract(value="_, _, _, _ -> fail")
    private void syntaxErrorSingleLine(@NotNull String compilerInput, @NotNull Token token, @NotNull String errorMsg, RecognitionException ex) {
        StringBuilder text = new StringBuilder(errorMsg).append(":\n").append(compilerInput).append('\n');
        int startIndex = token.getStartIndex();
        int stopIndex = token.getType() == -1 ? startIndex : token.getStopIndex();
        char[] marker = new char[stopIndex + 1];
        Arrays.fill(marker, 0, startIndex, ' ');
        Arrays.fill(marker, startIndex, stopIndex + 1, '^');
        throw this.createException(errorMsg, compilerInput, startIndex, stopIndex, text.append(marker).toString(), ex);
    }

    @NotNull
    protected RuntimeException createException(@NotNull String errorMsg, @NotNull String compilerInput, int startIndex, int stopIndex, @NotNull String visibleMarker, RecognitionException ex) {
        return new MessageMatcherParserException(compilerInput, startIndex, stopIndex, visibleMarker, ex);
    }

    protected AbstractAntlr4Compiler() {
    }

    public static enum Walker {
        WALK_FULL_RECURSIVE,
        WALK_FULL_HEAP,
        WALK_EXIT_RULES_ONLY,
        WALK_ENTRY_EXIT_RULES_ONLY;

    }

    public static interface WalkerSupplier {
        @Contract(pure=true)
        @NotNull
        public Walker getWalker();
    }

    public static interface CompilerInputSupplier {
        @Contract(pure=true)
        @NotNull
        public String getCompilerInput();
    }
}

