/*
 * Decompiled with CFR 0.152.
 */
package de.rototor.pdfbox.graphics2d;

import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DImageEncoder;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class PdfBoxGraphics2DLosslessImageEncoder
implements IPdfBoxGraphics2DImageEncoder {
    @Override
    public PDImageXObject encodeImage(PDDocument document, PDPageContentStream contentStream, Image image) {
        BufferedImage bi;
        if (image instanceof BufferedImage) {
            bi = (BufferedImage)image;
        } else {
            int height;
            int width = image.getWidth(null);
            bi = new BufferedImage(width, height = image.getHeight(null), 6);
            Graphics graphics = bi.getGraphics();
            if (!graphics.drawImage(image, 0, 0, null, null)) {
                throw new IllegalStateException("Not fully loaded images are not supported.");
            }
        }
        try {
            PDImageXObject imageXObject = LosslessFactory.createFromImage((PDDocument)document, (BufferedImage)bi);
            if (bi.getColorModel().getColorSpace() instanceof ICC_ColorSpace) {
                ICC_Profile profile = ((ICC_ColorSpace)bi.getColorModel().getColorSpace()).getProfile();
                if (bi.getColorModel().getColorSpace() != ICC_ColorSpace.getInstance(1000)) {
                    PDICCBased pdProfile = new PDICCBased(document);
                    OutputStream outputStream = pdProfile.getPDStream().createOutputStream();
                    outputStream.write(profile.getData());
                    outputStream.close();
                    imageXObject.setColorSpace((PDColorSpace)pdProfile);
                }
            }
            return imageXObject;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not encode Image", e);
        }
    }
}

